% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.sst.par.r
\name{calc.sst.par}
\alias{calc.sst.par}
\title{Calculate SST-based likelihood in parallel}
\usage{
calc.sst.par(tag.sst, filename, sst.dir, dateVec, focalDim = NULL,
  sens.err = 1, ncores = NULL)
}
\arguments{
\item{tag.sst}{is data frame containing tag-collected SST data}

\item{filename}{is the first part of the filename specified to the download 
function \code{\link{get.env}}. For example, if downloaded files were 
specific to a particular dataset, you may want to identify that with a name 
like 'tuna' or 'shark1'. This results in a downloaded filename of, for 
example, 'tuna_date.nc'. This filename is required here so the calc function
knows where to get the env data.}

\item{sst.dir}{local directory where remote sensing SST downloads are stored}

\item{dateVec}{is vector of dates from tag to pop-up in 1 day increments.}

\item{focalDim}{is integer for dimensions of raster::focal used to calculate 
sd() of env grid cell. If left to NULL (default), this dimension will 
approximately incorporate 0.25 degrees.}

\item{sens.err}{is numeric indicating the percent sensor error in the tag sst
sensor. Default is 1.}

\item{ncores}{is integer indicating number of cores used in this parallel
computation. Defaults to using a detection function that chooses cores for
you.}
}
\value{
likelihood is raster brick of likelihood surfaces representing matches
 between tag-based sst and remotely sensed sst maps
}
\description{
\code{calc.sst.par} compares tag SST to remotely sensed SST and calculates 
likelihoods in parallel
}
\seealso{
\code{\link{calc.sst}}
}
