% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expmax.r
\name{expmax}
\alias{expmax}
\title{Expectation-maximization framework for state-switching}
\usage{
expmax(p.init, g, L, K1, K2, niter = 1000, threshold = 0.01, save = F)
}
\arguments{
\item{p.init}{a vector of length 2. The first is the probability of staying 
in behavior state 1 if currently in state 1 and the second for staying in 
state 2.}

\item{g}{grid from \code{\link{setup.grid}}}

\item{L}{final likelihood}

\item{K1}{first movement (diffusion) kernel see \code{\link{gausskern}}}

\item{K2}{second movement (diffusion) kernel see \code{\link{gausskern}}}

\item{niter}{is integer that determines number of iterations to perform}

\item{threshold}{is threshold of percent change that we consider satisfactory
for convergence. Default is 1\%.}

\item{save}{is logical indicating whether the function should save and return
a 2 col dataframe of the iterations it went through before crossing the
convergence threshold. Defaults to not saving.}
}
\value{
a 2x2 matrix of state switching probabilities. See P.init input for 
  more information.
}
\description{
\code{expmax} performs expectation-maximization for state switching 
probability
}
\details{
Light errors are parameterized using elliptical error values output in.
}
\examples{

# GENERATE MOVEMENT KERNELS. D VALUES ARE MEAN AND SD PIXELS
K1 <- gausskern(3, 1, muadv = 0)
K2 <- gausskern(10, 5, muadv = 0)

# MAKE A GUESS AT STATE SWITCHING PROBABILITY
# probability of staying in state 1 and 2, respectively
p.init <- c(0.7, 0.8)

\dontrun{
# Not run as it relies on L, a large likelihood grid
# RUN EXPECTATION-MAXIMIZATION ROUTINE FOR MATRIX, P (STATE SWITCH PROBABILITY)
P.final <- expmax(p.init, g = g, L = L, K1, K2)

}
}
\references{
Woillez M, Fablet R, Ngo TT, et al. (2016) A HMM-based model to 
  geolocate pelagic fish from high-resolution individual temperature and 
  depth histories: European sea bass as a case study. Ecol Modell 321:10-22.
}
