% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHMM.r
\name{plotHMM}
\alias{plotHMM}
\title{Plot track results of HMMoce}
\usage{
plotHMM(distr, track, dateVec, ptt, known = NULL, resid = FALSE,
  behav.pts = F, save.plot = FALSE)
}
\arguments{
\item{distr}{is output array from \code{hmm.smoother}}

\item{track}{is output dataframe from \code{calc.track}}

\item{dateVec}{is vector of dates from tag to pop-up location by day.}

\item{ptt}{is unique ID for individual tag dataset}

\item{known}{is 3 column data frame containing date, lat, lon of known 
movement track. This is only useful for comparing HMMoce results to known 
track collected by SPOT or GPS, for example. Default is NULL.}

\item{resid}{is logical indicating whether you want to include a residual
plot. This is not yet functional.}

\item{behav.pts}{is logical indicating whether to plot points in the
resulting map colored by behav state.}

\item{save.plot}{is logical indicating whether you want the plot written to
disk using \code{pdf}.}
}
\value{
NULL. A plot is rendered on screen or written to disk.
}
\description{
\code{plotHMM} uses HMM output via \code{calc.track} to make simple plots of 
calculated track and behavior state
}
\references{
Pedersen MW, Patterson TA, Thygesen UH, Madsen H (2011)
  Estimating animal behavior and residency from movement data. Oikos
  120:1281-1290. doi: 10.1111/j.1600-0706.2011.19044.x
}
