% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cda.R
\name{cda}
\alias{cda}
\title{Cummulative difference approach (CDA) for homogeneous segmentation of spatial lines data.}
\usage{
cda(var = "deflection", length = "length", data, range = NULL)
}
\arguments{
\item{var}{A character or a character vector of variable names,
such as a road pavement performance indicator.}

\item{length}{A character of road length name in data.}

\item{data}{A data frame of a dataset.}

\item{range}{A vector of length threshold.}
}
\description{
Function for homogeneous segmentation of spatial lines data using
             a cummulative difference approach (CDA).
}
\examples{
testdata <- tsdwa[1:100,]
testdata$Length <- testdata$SLK.end - testdata$SLK.start
testdata <- cda(var = "Deflection", length = "Length", testdata)

}
