% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lassorda.r
\name{lasso_deltas}
\alias{lasso_deltas}
\title{Lasso Initial State}
\usage{
lasso_deltas(
  X,
  y,
  lambda = NULL,
  verbose = FALSE,
  alpha = 1,
  rank_fn = order_plain,
  k = ncol(X)
)
}
\arguments{
\item{X}{Design matrix of traning data; 
rows should be for the cases, and columns for different features.}

\item{y}{Vector of class labels in training or test data set. 
Must be coded as non-negative integers, e.g., 1,2,\ldots,C for C classes.}

\item{lambda}{A user supplied lambda sequence for \code{glmnet} cross-validation.
\code{NULL} by default, and it will be generated by \code{glmnet}.}

\item{alpha}{The elasticnet mixing parameter for \code{glmnet}.}
}
\value{
A matrix - the initial state of Markov Chain for HTLR model fitting.
}
\description{
Generate initial Markov chain state with Lasso.
}
\references{
Jerome Friedman, Trevor Hastie, Robert Tibshirani (2010).
Regularization Paths for Generalized Linear Models via Coordinate
Descent. \emph{Journal of Statistical Software}, 33(1), 1-22.
}
\seealso{
\code{\link{bcbcsf_deltas}}
}
\keyword{internal}
