/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.util;

import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class StringUtilities {
    public static final int ELLIPSIS_LENGTH_LONG = 2000;
    public static final int ELLIPSIS_LENGTH_SHORT = 400;
    public static String PREFERENCES_DIRECTORY = ".ptolemyII";

    private StringUtilities() {
    }

    public static String abbreviate(String string) {
        if (string == null) {
            return "<Unnamed>";
        }
        if (string.length() < 80) {
            return string;
        }
        return string.substring(0, 37) + ". . ." + string.substring(string.length() - 38);
    }

    public static String ellipsis(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string = StringUtilities.split(string), "\n", true);
        if (stringTokenizer.countTokens() > 20) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < 20 && stringTokenizer.hasMoreTokens(); ++i) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
            stringBuffer.append("...");
            string = stringBuffer.toString();
        }
        if (string.length() > n) {
            return string.substring(0, n - 3) + "...";
        }
        return string;
    }

    public static String escapeForXML(String string) {
        string = StringUtilities.substitute(string, "&", "&amp;");
        string = StringUtilities.substitute(string, "\"", "&quot;");
        string = StringUtilities.substitute(string, "<", "&lt;");
        string = StringUtilities.substitute(string, ">", "&gt;");
        string = StringUtilities.substitute(string, "\n", "&#10;");
        return string;
    }

    public static String getIndentPrefix(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        return stringBuffer.toString();
    }

    public static String preferencesDirectory() throws IOException {
        String string = StringUtilities.getProperty("user.home") + StringUtilities.getProperty("file.separator") + PREFERENCES_DIRECTORY + StringUtilities.getProperty("file.separator");
        File file = new File(string);
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("Could not create user preferences directory '" + string + "'");
        }
        return string;
    }

    public static String getProperty(String string) {
        String string2;
        block19: {
            string2 = null;
            try {
                string2 = System.getProperty(string);
            }
            catch (SecurityException securityException) {
                if (string.equals("ptolemy.ptII.dir")) break block19;
                throw new RuntimeException("Could not find '" + string + "' System property", securityException);
            }
        }
        if (string.equals("user.dir")) {
            try {
                File file = new File(string2);
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return string2;
            }
        }
        if (string2 != null) {
            return string2;
        }
        if (string.equals("ptolemy.ptII.dirAsURL")) {
            File file = new File(StringUtilities.getProperty("ptolemy.ptII.dir"));
            try {
                URL uRL = file.toURL();
                return uRL.toString();
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("While trying to find '" + string + "', could not convert '" + file + "' to a URL", malformedURLException);
            }
        }
        if (string.equals("ptolemy.ptII.dir")) {
            String string3 = "ptolemy/kernel/util/NamedObj.class";
            String string4 = null;
            URL uRL = Thread.currentThread().getContextClassLoader().getResource(string3);
            if (uRL != null) {
                String string5;
                String string6;
                String string7 = uRL.getFile().toString();
                if (string7.startsWith("file:")) {
                    string7 = string7.substring(6);
                }
                if ((string4 = new File(string6 = string7.substring(0, string7.length() - string3.length())).toString()).endsWith("!")) {
                    string4 = string4.substring(0, string4.length() - 1);
                }
                if (string4.endsWith(string5 = File.separator + "DMptolemy" + File.separator + "RMptsupport.jar")) {
                    string4 = string4.substring(0, string4.length() - string5.length());
                }
                if (string4.endsWith(string5 = File.separator + "ptolemy" + File.separator + "ptsupport.jar")) {
                    string4 = string4.substring(0, string4.length() - string5.length());
                }
            }
            if (string4 == null) {
                throw new RuntimeException("Could not find 'ptolemy.ptII.dir' property.  Also tried loading '" + string3 + "' as a resource and working from that. " + "Vergil should be " + "invoked with -Dptolemy.ptII.dir" + "=\"$PTII\"");
            }
            try {
                System.setProperty("ptolemy.ptII.dir", string4);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return string4;
        }
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static String sanitizeName(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isJavaIdentifierPart(cArray[i])) continue;
            cArray[i] = 95;
        }
        if (!Character.isJavaIdentifierStart(cArray[0])) {
            return "_" + new String(cArray);
        }
        return new String(cArray);
    }

    public static String split(String string) {
        if (string == null) {
            return "<Unnamed>";
        }
        if (string.length() < 80) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = 0;
            while (n < string2.length() - 79) {
                int n2 = string2.substring(n, n + 79).lastIndexOf(" ");
                if (n2 < 0) {
                    stringBuffer.append(string2.substring(n, n + 79) + "\n");
                    n += 79;
                    continue;
                }
                stringBuffer.append(string2.substring(n, n + n2) + "\n");
                n += n2 + 1;
            }
            stringBuffer.append(string2.substring(n));
        }
        return stringBuffer.toString();
    }

    public static String substitute(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        while (n != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.delete(n, n + string2.length());
            stringBuffer.insert(n, string3);
            string = new String(stringBuffer);
            n = string.indexOf(string2, n + string3.length());
        }
        return string;
    }

    public static String[] tokenizeForExec(String string) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 127);
        streamTokenizer.ordinaryChar(34);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        block6: while (streamTokenizer.nextToken() != -1) {
            switch (streamTokenizer.ttype) {
                case -3: {
                    if (bl) {
                        if (string2.length() > 0) {
                            string2 = string2 + " ";
                        }
                        string2 = string2 + string3 + streamTokenizer.sval;
                    } else {
                        string2 = string3 + streamTokenizer.sval;
                        linkedList.add(string2);
                    }
                    string3 = "";
                    continue block6;
                }
                case -2: {
                    throw new RuntimeException("Internal error: Found TT_NUMBER: '" + streamTokenizer.nval + "'.  We should not be " + "tokenizing numbers");
                }
                case 10: {
                    continue block6;
                }
                case -1: {
                    continue block6;
                }
            }
            string3 = new Character((char)streamTokenizer.ttype).toString();
            if (!string3.equals("\"")) continue;
            if (bl) {
                linkedList.add(string2);
            }
            bl = !bl;
            string3 = "";
            string2 = "";
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String usageString(String string, String[][] stringArray, String[] stringArray2) {
        int n;
        String string2 = "Usage: " + string + "\n\n" + "Options that take values:\n";
        for (n = 0; n < stringArray.length; ++n) {
            string2 = string2 + " " + stringArray[n][0] + " " + stringArray[n][1] + "\n";
        }
        string2 = string2 + "\nBoolean flags:\n";
        for (n = 0; n < stringArray2.length; ++n) {
            string2 = string2 + " " + stringArray2[n];
        }
        return string2;
    }
}

