% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_BarplotUpstreamClasses.R
\name{BarplotUpstreamClasses}
\alias{BarplotUpstreamClasses}
\title{Bar plots of upstream-averaged classes of HYPE sub-basins}
\usage{
BarplotUpstreamClasses(
  x,
  type = c("custom", "landuse", "soil", "crop"),
  desc = NULL,
  class.names = NULL,
  xlab = NULL,
  ylab = "Area fraction (\%)",
  ylim = c(-0.05, max(x[, -1] * 150)),
  names.arg = rep("", ncol(x) - 1),
  cex.axis = 1,
  cex.names = 0.9,
  col = NULL,
  border = NA,
  legend.text = NULL,
  legend.pos = "left",
  pars = list(mar = c(1.5, 3, 0.5, 0.5) + 0.1, mgp = c(1.5, 0.3, 0), tcl = NA, xaxs =
    "i")
)
}
\arguments{
\item{x}{Data frame, containing column-wise class group fractions with SUBIDs in first column. Typically a result
from \code{\link{UpstreamGroupSLCClasses}}. Column names of class group fractions \emph{must} end with \code{_x}, with x giving the
class group ID, see details.}

\item{type}{Character string keyword for class group labeling, used in combination with \code{desc}. Type of class groups,
either \code{"landuse"}, \code{"soil"}, or \code{"crop"} (abbreviations allowed). If \code{"custom"} (default),  labeling can be fine-
tuned with argument \code{class.names}.}

\item{desc}{List for use with \code{type}. Class description labels imported from a 'description.txt' file, for labeling of
standard class groups. See \code{\link{ReadDescription}} for formatting details.}

\item{class.names}{Character vector of class group names, with same length as number of class group fractions in \code{x}.
Specification of bar labels, alternative to arguments \code{type} and \code{desc}, in particular for cases where a non-standard
grouping was used for \code{x}.}

\item{xlab}{Character string, x-axis label, with defaults for standard groups land use, soil, and crops.}

\item{ylab}{Character string, y-axis label.}

\item{ylim}{Numeric, two element vector with limits for the y-axis. Defaults to values which give ample space for bar labels.}

\item{names.arg}{Character vector, see \code{\link{barplot}}. Defaults to no labeling below bars (text labels within plot through
arguments above).}

\item{cex.axis}{Numeric, character expansion factor for axis annotation and labels.}

\item{cex.names}{Numeric, character expansion factor for class group labels.}

\item{col}{Colors for bars. Defaults to \code{type}-specific pre-defined color.}

\item{border}{Colors for bar borders. Defaults to no borders.}

\item{legend.text}{Character, if provided, a legend will be plotted. Defaults to none if one sub-basin is plotted, and SUBIDs
if several sub-basins are plotted. Set to \code{NA} to prevent legend plotting in any case.}

\item{legend.pos}{Character keyword for legend positioning, most likely \code{"left"} or \code{"right"}. For details, see
\code{\link{legend}}.}

\item{pars}{List of tagged values which are passed to \code{\link{par}}.}
}
\value{
The function returns bar midpoints, see description in \code{\link{barplot}}.
}
\description{
Function to plot upstream-averaged landscape property classes of one or several sub-basins as bar plots, e.g.
land use or soils. Builds on \code{\link{barplot}}.
}
\details{
\code{BarplotUpstreamClasses} is a wrapper for \code{\link{barplot}}, with vertical labels plotted over the class group bars.
Most arguments have sensible defaults, but can be adapted for fine-tuning if necessary.

Column names of \code{x} are used to link class groups to class IDs in \code{desc}. HYPE has no formal
requirements on how class IDs are numbered and when one of the standard groups land use, soil, or crop are provided in \code{x},
there might be missing class IDs. Class names in \code{desc} are matched against column name endings \code{'_x'} in \code{x}.
If manual names are provided in \code{class.names}, the column name endings must be a consecutive sequence from 1 to number of elements
in \code{class.names}.
}
\examples{
# Import source data
te1 <- ReadGeoData(filename = system.file("demo_model", "GeoData.txt", package = "HYPEtools"))
te2 <- ReadGeoClass(filename = system.file("demo_model", "GeoClass.txt", package = "HYPEtools"))
te3 <- ReadDescription(filename = system.file("demo_model", "description.txt", 
                       package = "HYPEtools"))
# Calculate plot data, upstream soil fractions
te4 <- UpstreamGroupSLCClasses(subid = 63794, gd = te1, gcl = te2, type = "soil")
# Function call
BarplotUpstreamClasses(x = te4, type = "s", desc = te4, ylim = c(0,100))

}
\seealso{
\code{\link{UpstreamGroupSLCClasses}}
\code{\link{barplot}}
}
