% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woods_plot.R
\name{woods_plot}
\alias{woods_plot}
\title{Plot Woods' plot}
\usage{
woods_plot(calc_dat, theoretical = FALSE, relative = TRUE,
  confidence_limit = 0.98, confidence_limit_2 = 0.99)
}
\arguments{
\item{calc_dat}{data as imported by the \code{\link{read_hdx}} function and processed by the \code{\link{prepare_dataset}} function.}

\item{theoretical}{\code{logical}, determines if plot shows theoretical values.}

\item{relative}{\code{logical}, determines if values are relative or absolute.}

\item{confidence_limit}{confidence limit.}

\item{confidence_limit_2}{confidence limit 2.}
}
\description{
Produces Woods' plot based on theoretical or experimental HDX-MS data.
}
\examples{
dat <- read_hdx(system.file(package = "HaDeX", 
                            "HaDeX/data/KD_180110_CD160_HVEM.csv"))
calc_dat <- prepare_dataset(dat,
                            in_state_first = "CD160_0.001",
                            chosen_state_first = "CD160_1",
                            out_state_first = "CD160_1440",
                            in_state_second = "CD160_HVEM_0.001",
                            chosen_state_second = "CD160_HVEM_1",
                            out_state_second = "CD160_HVEM_1440") 
woods_plot(calc_dat = calc_dat,
           theoretical = TRUE,
           relative = TRUE,
           confidence_limit = 0.98,
           confidence_limit_2 = 0.99)
woods_plot(calc_dat = calc_dat,
           theoretical = FALSE,
           relative = TRUE,
           confidence_limit = 0.98,
           confidence_limit_2 = 0.99)
woods_plot(calc_dat = calc_dat,
           theoretical = TRUE,
           relative = FALSE,
           confidence_limit = 0.98,
           confidence_limit_2 = 0.99)
woods_plot(calc_dat = calc_dat,
           theoretical = FALSE,
           relative = FALSE,
           confidence_limit = 0.98,
           confidence_limit_2 = 0.99)
            
}
\references{
Woods, V.L., and Hamuro, Y. (2001). High resolution, 
high-throughput amide deuterium exchange-mass spectrometry (DXMS) 
determination of protein binding site structure and dynamics: utility 
in pharmaceutical design. J. Cell. Biochem. Suppl. Suppl 37, 89–98.
}
