% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.LD50.R
\name{predict.LD50}
\alias{predict.LD50}
\title{Estimate survival according to doses}
\usage{
\method{predict}{LD50}(object, doses = NULL, SE = NULL,
  range.CI = 0.95, replicates = 1000, progressbar = FALSE, ...)
}
\arguments{
\item{object}{A result file generated by LD50}

\item{doses}{A vector of temperatures}

\item{SE}{The standard error for doses, optional}

\item{range.CI}{The range of confidence interval for estimation, default=0.95}

\item{replicates}{Number of replicates to estimate CI}

\item{progressbar}{Logical. Does a progression bar must be shown}

\item{...}{Not used}
}
\value{
A data.frame with informations about survival
}
\description{
Estimate survival according to doses.\cr
The returned data.frame has the following components:\cr
doses, SE, survival, CI.minus.sexratio, CI.plus.sexratio, range.CI\cr
}
\details{
predict.LD50 Estimate survival according to doses
}
\examples{
\dontrun{
#' data <- data.frame(Doses=c(80, 120, 150, 150, 180, 200),
Alive=c(10, 12, 8, 6, 2, 1),
Dead=c(0, 1, 5, 6, 9, 15))
LD50_logistic <- LD50(data, equation="logistic")
predict(LD50_logistic, doses=c(140, 170))
plot(LD50_logistic
}
}
\seealso{
Other LD50 functions: \code{\link{LD50}},
  \code{\link{logLik.LD50}}, \code{\link{plot.LD50}}
}
\author{
Marc Girondot
}
\concept{LD50 functions}
