% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qSnbinom.R
\name{qSnbinom}
\alias{qSnbinom}
\title{Quantile function for the sum of random variable with negative binomial distributions.}
\usage{
qSnbinom(p = stop("At least one probability must be provided"),
  size = stop("size parameter is mandatory"), prob = NULL, mu = NULL,
  lower.tail = TRUE, log.p = FALSE, tol = 1e-06)
}
\arguments{
\item{p}{vector of probabilities.}

\item{size}{target for number of successful trials, or dispersion parameter (the shape parameter of the gamma mixing distribution). Must be strictly positive, need not be integer.}

\item{prob}{probability of success in each trial. 0 < prob <= 1.}

\item{mu}{alternative parametrization via mean.}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x], otherwise, P[X > x].}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{tol}{Tolerance for recurrence}
}
\value{
qSnbinom returns quantile function
}
\description{
Quantile function for the sum of random variable with negative binomial distributions.
}
\details{
qSnbinom returns the quantile function for the sum of random variable with negative binomial distributions
}
\examples{
\dontrun{
alpha <- c(2.1, 2.05, 2)
mu <- c(10, 30, 20)
q <- qSnbinom(p=0.1, size=alpha, mu=mu, lower.tail = TRUE)
}
}
\seealso{
Other Distribution of sum of random variable with negative binomial distributions: \code{\link{dSnbinom}},
  \code{\link{pSnbinom}}, \code{\link{rSnbinom}}
}
\author{
Marc Girondot
}
\concept{Distribution of sum of random variable with negative binomial distributions}
