% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnbinom_new.R
\name{dnbinom_new}
\alias{dnbinom_new}
\title{Random numbers for the negative binomial distribution.}
\usage{
dnbinom_new(
  x,
  size = NULL,
  prob = NULL,
  mu = NULL,
  sd = NULL,
  var = NULL,
  log = FALSE
)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{size}{target for number of successful trials, or dispersion parameter (the shape parameter of the gamma mixing distribution). Must be strictly positive, need not be integer.}

\item{prob}{probability of success in each trial. 0 < prob <= 1.}

\item{mu}{alternative parametrization via mean.}

\item{sd}{alternative parametrization via standard deviation.}

\item{var}{alternative parametrization via variance.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}
}
\value{
Random numbers for the negative binomial distribution
}
\description{
Density for the negative binomial distribution with parameters mu, sd, var, size or prob. See \code{dnbinom}.
}
\details{
dnbinom_new returns density for the negative binomial distribution
}
\examples{
\dontrun{
library("HelpersMG")
set.seed(1)
x <- rnbinom_new(n=100, mu=2, sd=3)
LnL <- NULL
df <- data.frame(mu=seq(from=0.1, to=8, by=0.1), "-LnL"=NA)
for (mu in df[, "mu"])
LnL <- c(LnL, -sum(dnbinom_new(x=x, mu=mu, sd=3, log=TRUE)))
df[, "-LnL"] <- LnL
ggplot(data = df, aes(x = .data[["mu"]], y = .data[["-LnL"]])) + geom_line()
# Examples of wrong parametrization
dnbinom_new(x=x, mu=c(1, 2), sd=3, log=TRUE)
}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
