% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeriTools.R
\name{fit.NB}
\alias{fit.NB}
\title{Fit negative binomial mixed models (NBMM) for one or more features.}
\usage{
fit.NB(CountMatrix, Strains, test = FALSE)
}
\arguments{
\item{CountMatrix}{Sequencing count matrix for a list of features. Each row 
is for one feature, and the columns are for samples.}

\item{Strains}{Strain labels for the samples.}

\item{test}{TRUE or FALSE (default). Test the presence of heritability 
through examining the random effect variance \eqn{\sigma_g^2 = 0}{}.}
}
\value{
A list with two objects. The first object is a \eqn{G \times 3}{G x 3} 
matrix indicating the fitted parameters for each feature. The columns are 
ordered by \eqn{\alpha_g, \sigma_g^2, \phi_g}. 
Row names are feature names. If the argument test is set to
be true, the second object of the list consists of p-values for testing 
the hypothesis that random effects \eqn{\sigma_a^2 = 0}{sigma_a2 = 0}; 
otherwise, the second object is NULL.
}
\description{
Fit NBMM for one or more features and output the fit parameters. 
It is used before the function computeVPC.NB(). This function also allows 
to test the presence of heritability via random effect variance of the model. To fit a NBMM, the glmmADMB package is needed.
}
\examples{
\donttest{
## Compute vpc for each feature under NBMM. This will take a while on the
##  entire dataset. For the purpose of illustration, here we only fit on 
##  the first 2 features.
library(glmmADMB)
result.nb <- fit.NB(simData[1:2, ], strains)
}
}

