% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeriTools.R
\name{getBootCI}
\alias{getBootCI}
\title{Compute variance partition coefficition (VPC) confidence intervals (CI) 
for one or more features.}
\usage{
getBootCI(CountMatrix, Strains, which.features, num.boot, method = "NB-fit",
  alpha = 0.05, optimizer = "nlminb")
}
\arguments{
\item{CountMatrix}{A \eqn{G\times N} count matrix. \eqn{G} is the number of 
features; \eqn{N} is the total number of samples.}

\item{Strains}{A \eqn{1\times N} vector of strain labels corresponding to 
each sample.}

\item{which.features}{A \eqn{1\times k} vector of select feature numbers 
for which CI is desired. \eqn{k\leq G}.}

\item{num.boot}{Number of bootstraps.}

\item{method}{Which method should be used, "CP-fit", "NB-fit" (default), 
or "VST". "VST" method bootstraps data under negative binomial mixed models.}

\item{alpha}{A numerical value between 0 and 1, indicating the significance 
level of the CI. The CI will be \eqn{100*(1-\alpha)}{100*(1-alpha)} 
percent CI. Default value is 0.05.}

\item{optimizer}{A character string that determines which optimization 
routine is to be used. It is only used for method = "CP-fit". Possible 
choices are "nlminb" (default), "L-BFGS-B", and "bobyqa".}
}
\value{
A list of two objects. The first object is a \eqn{k \times 2} 
matrix containing the CI. The second object consists of a 
\eqn{k \times}num.boot matrix of all bootsrapped VPC values.
}
\description{
Compute VPC CI based on parametric bootstrap for one or more features.
}
\examples{
\donttest{
## Compute CI based on 100 bootstrap samples for the first feature 
##  under NBMM. It takes a few minutes.
NBboot <- getBootCI(simData, strains, 1, 100)
## Extract CI
NBboot.ci <- NBboot[[1]]
## Extract vpcs
NBboot.vpc <- NBboot[[2]]

## Compute CI based on 100 bootstrap samples for the first feature
##  under vst. 
VSTboot <- getBootCI(simData, strains, 1, 100, method = "VST")
}

}

