% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Met_MatH.R
\name{WH.SSQ}
\alias{WH.SSQ}
\alias{WH.SSQ,MatH-method}
\title{Method WH.SSQ}
\usage{
WH.SSQ(object, ...)

\S4method{WH.SSQ}{MatH}(object, w = numeric(0))
}
\arguments{
\item{object}{a \code{MatH} object}

\item{...}{some optional parameters}

\item{w}{it is possible to add a vector of weights (positive numbers) 
having the same size of the rows of the \code{MatH object}, 
default = equal weight for each row}
}
\value{
a squared \code{matrix} with the weighted sum of squares
}
\description{
Compute the sum-of-squares-deviations (from the mean) matrix of a \code{MatH} object, i.e. 
a matrix of numbers, consistent with 
a set of distributions equipped with a L2 wasserstein metric.
}
\examples{
WH.SSQ(BLOOD)
# generate a set of random weights
RN<-runif(get.MatH.nrows(BLOOD))
WH.SSQ(BLOOD,w=RN)
}
