% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fuzzy_cmeans.R
\name{WH_adaptive_fcmeans}
\alias{WH_adaptive_fcmeans}
\title{Fuzzy c-means with adaptive distances for histogram-valued data}
\usage{
WH_adaptive_fcmeans(
  x,
  k = 5,
  schema,
  m = 1.6,
  rep,
  simplify = FALSE,
  qua = 10,
  standardize = FALSE,
  init.weights = "EQUAL",
  weight.sys = "PROD",
  theta = 2,
  verbose = FALSE
)
}
\arguments{
\item{x}{A MatH object (a matrix of distributionH).}

\item{k}{An integer, the number of groups.}

\item{schema}{An integer. 1=one weight per variable, 2=two weights per variables (one for each component: the mean and the variability component),
3=one weight per variable and per cluster, 4= two weights per variable and per cluster.}

\item{m}{A number grater than 0, a fuzziness coefficient (default \code{m}=1.6).}

\item{rep}{An integer, maximum number of repetitions of the algorithm (default \code{rep}=5).}

\item{simplify}{A logic value (default is FALSE), if TRUE histograms are recomputed in order to speed-up the algorithm.}

\item{qua}{An integer, if \code{simplify}=TRUE is the number of quantiles used for recodify the histograms.}

\item{standardize}{A logic value (default is FALSE). If TRUE, histogram-valued data are standardized,  variable by variable, using the Wassertein based standard deviation. Use if one wants to have variables with std equal to one.}

\item{init.weights}{A string. (default='EQUAL'). EQUAL, all variables or components have the same weight; 'RANDOM', a random assignment is done.}

\item{weight.sys}{A string. (default='PROD') PROD, Weights product is equal to one. SUM, the weights sum up to one.}

\item{theta}{A number. (default=2) A parameter for the system of weights summing up to one.}

\item{verbose}{A logic value (default is FALSE). If TRUE  some details are provided.}
}
\value{
The results of the fuzzy c-means of the set of Histogram-valued data \code{x} into  \code{k} cluster.
\item{solution}{A list.Returns the best solution among the \code{rep}etitions, i.e. the ona having the minimum sum of squares deviation.}
\item{solution$membership}{A matrix. The membership degree of each unit to each cluster.}
\item{solution$IDX}{A vector. The crisp assignement to a cluster.}
\item{solution$cardinality}{A vector. The cardinality of each final cluster (after the crisp assignement).}
\item{solution$Crit}{A number. The criterion (Sum od square deviation from the prototypes) value at the end of the run.}
\item{quality}{A number. The percentage of Sum of square deviation explained by the model. (The higher the better)}
}
\description{
Fuzzy c-means of a dataset of histogram-valued data using different adaptive distances based on the L2 Wasserstein metric.
}
\examples{
results=WH_adaptive_fcmeans(x = BLOOD,k = 2,schema=4,m = 1.5,rep = 3,simplify = TRUE,
                           qua = 10,standardize = TRUE,init.weights='EQUAL', weight.sys='PROD')
}
