% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preproc_validate_daily.R
\name{preproc_validate_daily}
\alias{preproc_validate_daily}
\title{Validates that daily data do not contain gaps}
\usage{
preproc_validate_daily(
  data = NULL,
  Date = "Date",
  value = "value",
  date_format = "\%Y-\%m-\%d"
)
}
\arguments{
\item{data}{'data.frame'. Optional data.frame input, with columns containing \code{Date} and \code{value}.
Column names are specified as strings in the corresponding parameter. Default is \code{NULL}.}

\item{Date}{'Date' or 'character' vector when \code{data = NULL}, or 'character' string identifying
Date column name when \code{data} is specified. Dates associated with each value in \code{value}
parameter.}

\item{value}{'numeric' vector when \code{data = NULL}, or 'character' string identifying year column
name when \code{data} is specified. Values to precondition and calculate n-day moving averages
from. N-day moving averages only calculated for daily data.}

\item{date_format}{'character' string. Format of \code{Date}. Default is \code{"\%Y-\%m-\%d"}.}
}
\value{
An error message with missing dates, otherwise nothing.
}
\description{
Validates that daily data do not contain gaps
}
\details{
Used to validate there are no gaps in the daily record before computing n-day moving averages in
\code{\link{preproc_precondition_data}} or lag-1 autocorrelation in \code{\link{POR_calc_AR1}}. If gaps are present,
\code{\link{preproc_fill_daily}} can be used to fill them with \code{NA} values.
}
\examples{
preproc_validate_daily(data = example_obs, Date = "Date", value = "streamflow_cfs")

}
\keyword{preprocessing-data}
