% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.HydeNetwork.R
\name{plot.HydeNetwork}
\alias{HydePlotOptions}
\alias{customNode}
\alias{mapEdges}
\alias{mergeCustomEdges}
\alias{mergeCustomNodes}
\alias{plot.HydeNetwork}
\alias{plotHydeNetwork}
\title{Plotting Utilities Probabilistic Graphical Network}
\source{
\url{http://rich-iannone.github.io/DiagrammeR/graphviz_and_mermaid.html}\cr
  See especially the section on Attributes
  
  \url{http://graphviz.org/}\cr
  \url{http://graphviz.org/content/attrs}
}
\usage{
\method{plot}{HydeNetwork}(x, customNodes = NULL, customEdges = NULL, ...,
  removeDeterm = FALSE, useHydeDefaults = TRUE)

mergeCustomNodes(node_df, customNodes)

mapEdges(n, p)

mergeCustomEdges(edge_df, customEdges)

customNode(node_id, ...)

HydePlotOptions(variable = NULL, determ = NULL, decision = NULL,
  utility = NULL, restorePackageDefaults = FALSE)
}
\arguments{
\item{x}{an object of class \code{HydeNetwork}}

\item{customNodes}{a data frame giving additional specifications for nodes.
The customizations provided here will override the default settings.}

\item{customEdges}{a data frame giving custom settings for edges (arrows)
between nodes.}

\item{...}{for the \code{plot} method, additional arguments to be passed to 
\code{DiagrammeR::render_graph}.  For \code{customNode}, 
named node attributes to assign to a node's plotting characteristics.}

\item{removeDeterm}{A logical value.  When \code{FALSE} (the default), 
it has no effect.  When \code{TRUE}, deterministic nodes are removed
from the network and a reduced plot with no deterministic nodes
is rendered.}

\item{useHydeDefaults}{A logical value indicating if the default plot
parameters in \code{options("Hyde_plotOptions")} should be applied
to the plot.}

\item{node_df}{A data frame of node attributes}

\item{n}{node names from a network object}

\item{p}{the list of parents from a network object}

\item{edge_df}{The default edge attribute data frame}

\item{node_id}{The name of a node in a \code{HydeNetwork} object.
May be quoted or unquoted.}

\item{variable, determ, decision, utility}{Named lists of attributes to use as 
defaults node attribute settings for each variable type.}

\item{restorePackageDefaults}{A logical value.  When TRUE, the original 
package defaults are restored.}
}
\description{
Generate and customize plots of a \code{HydeNetwork} 
  class network. \code{HydeNet} provides some initial defaults for standard 
  variable nodes, deterministic nodes, decision nodes, and utility nodes.
  Since these nodes are assumed to be of inherent difference and interest, 
  the options are defined in a way to make these easier to identify in 
  a plot.  The default options may be altered by the user to their liking
  by invoking \code{HydePlotOptions}.  Node attributes are more fully 
  explained in the documentation for the \code{DiagrammeR} package.  
  Individual nodes may be define with \code{customNode}.
}
\details{
GraphViz is an enormous set of resources for customizing and we 
  cannot adequately describe them all here.  See 'Sources' for links 
  to additional documentation from the \code{DiagrammeR} package and the 
  GraphViz website.
  
  With its default settings, \code{HydeNet} makes use of five node 
  attributes for plotting networks.  These are 
  \itemize{
    \item style: By default, set to 'filled', but may also take 'striped',
      'wedged', or 'radial'.
    \item fillcolor: The hexadecimal or X11 color name.  In styles 'striped',
      'wedged', or 'radial', this may take multiple colors separated by a 
      colon (:).
    \item shape: the node shape.  May take the values 'oval', 'diamond',
      'egg', 'ellipse', 'square', 'triangle', or 'rect'
    \item fontcolor: The color of the node label.
    \item color: The color of the node's border.
   }
   
  \code{HydeNet} assumes the GraphViz defaults for edge nodes (arrows).
  
  See the Plotting Hyde Networks vignette (\code{vignette("HydeNetPlots")})
  for a more thorough explanation of plotting networks.
}
\examples{
\dontrun{
#* Plots may open in a browser.
data(BlackJack, package="HydeNet")
plot(BlackJack)

HydePlotOptions(variable=list(shape = "rect", fillcolor = "#A6DBA0"),
                determ = list(shape = "rect", fillcolor = "#E7D4E8",
                              fontcolor = "#1B7837", linecolor = "#1B7837"),
                decision = list(shape = "triangle", fillcolor = "#1B7837",
                                linecolor = "white"),
                utility = list(shape = "circle", fillcolor = "#762A83", 
                               fontcolor = "white"))
plot(BlackJack)

HydePlotOptions(restorePackageDefaults = TRUE)

plot(BlackJack,
     customNodes = customNode(payoff, 
                              fillcolor = "purple", shape = "circle", 
                              fontcolor = "white", height = "2",
                              style="filled"))
plot(BlackJack,
  customNodes = 
    dplyr::bind_rows(
      customNode(pointsAfterCard3,
                 shape = "circle",
                 style = "radial",
                 fillcolor = "#1B7837:#762A83",
                 fontcolor = "black",
                 height = "2"),
      customNode(playerFinalPoints,
                 shape = "circle",
                 style = "wedged",
                 height = "3",
                 fillcolor = c("red:orange:yellow:green:blue:purple"))))
}
}
\author{
Jarrod Dalton and Benjamin Nutter
}

