% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vectorProbs.R
\name{vectorProbs}
\alias{vectorProbs}
\title{Convert a vector to JAGS Probabilities}
\usage{
vectorProbs(p, node, normalize = TRUE)
}
\arguments{
\item{p}{a vector of counts, weights, or probabilities.}

\item{node}{the node for the parameters.  this is converted to a character
string.  It is important that this be given accurately or it will not 
match with the code written by \code{writeNetworkModel}.}

\item{normalize}{A logical indicating if the weights in \code{p} should
be normalized (each value is taken as a proportion of the sum).}
}
\description{
Probability vectors can be passed manually to the model, but
  they must be formatted in code appropriate to JAGS.  \code{vectorProbs}
  will convert a vector of counts or weights to probabilities and format
  it into JAGS code.
}
\examples{
vectorProbs(c(1, 2, 3), "wells")

}
\author{
Jarrod Dalton and Benjamin Nutter
}
