% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pyramid.R
\name{plot.population}
\alias{plot.population}
\title{Plot the age pyramid of a population data frame (at a given time).}
\usage{
\method{plot}{population}(
  x,
  group_colors = NULL,
  group_legend = "Group",
  age_breaks = NULL,
  value_breaks = NULL,
  ...
)
}
\arguments{
\item{x}{Object of class \link{population}.}

\item{group_colors}{\emph{(Optional)} Named character vector.}

\item{group_legend}{\emph{(Optional)} Legend title name. By default set to \code{"Group"}.}

\item{age_breaks}{\emph{(Optional)} An ordered vector of indexes of vector \code{unique(pyr$age)} used for breaks for the axis of ages.}

\item{value_breaks}{\emph{(Optional)} Breaks for the axis of values.}

\item{...}{Additional arguments}
}
\value{
Plot of age pyramid.
}
\description{
Plot an age pyramid from age pyramid data frame with possibly several characteristics.
}
\examples{
plot(population(EW_pop_14$sample), time = 0)

}
\seealso{
\code{\link{plot.pyramid}}, \code{\link{age_pyramid.population}}.
}
