% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{GetVAF}
\alias{GetVAF}
\alias{GetStrelkaVAF}
\alias{GetMutectVAF}
\title{Extract the VAFs (variant allele frequencies) from a VCF file.}
\usage{
GetStrelkaVAF(vcf)

GetMutectVAF(vcf, name.of.VCF = NULL, tumor.col.name = NA)
}
\arguments{
\item{vcf}{Said VCF as a data.frame.}

\item{name.of.VCF}{Name of the VCF file.}

\item{tumor.col.name}{Name of the column in VCF which contains the tumor
sample information. It \strong{must} have quotation marks. If
\code{tumor.col.name} is equal to \code{NA}(default), this function will
use the 10th column to calculate VAFs.}
}
\value{
A vector of VAFs, one for each row of \code{vcf}.
}
\description{
Extract the VAFs (variant allele frequencies) from a VCF file.
}
\examples{
file <- c(system.file("extdata",
                      "Strelka.SBS.GRCh37.vcf",
                      package = "ICAMS"))
MakeDataFrameFromStrelkaSBSVCF <- 
  getFromNamespace("MakeDataFrameFromStrelkaSBSVCF", "ICAMS")
df <- MakeDataFrameFromStrelkaSBSVCF(file)
vaf <- GetStrelkaVAF(df)
}
