% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{CollapseCatalog}
\alias{CollapseCatalog}
\alias{Collapse192CatalogTo96}
\alias{Collapse1536CatalogTo96}
\alias{Collapse144CatalogTo78}
\title{"Collapse" a catalog.}
\usage{
Collapse192CatalogTo96(catalog)

Collapse1536CatalogTo96(catalog)

Collapse144CatalogTo78(catalog)
}
\arguments{
\item{catalog}{A catalog as defined in \code{\link{ICAMS}}.}
}
\value{
A catalog as defined in \code{\link{ICAMS}}.
}
\description{
\enumerate{
\item Take a mutational spectrum or signature catalog
that is based on a fined-grained set of features (for example, single-nucleotide
substitutions in the context of the preceding and following 2 bases).

\item Collapse it to a catalog based on a coarser-grained set of features
(for example, single-nucleotide substitutions in the context of the
immediately preceding and following bases).
}

\code{Collapse192CatalogTo96} Collapse an SBS 192 catalog
to an SBS 96 catalog.

\code{Collapse1536CatalogTo96} Collapse an SBS 1536 catalog
 to an SBS 96 catalog.

\code{Collapse144CatalogTo78} Collapse a DBS 144 catalog
to a DBS 78 catalog.
}
\examples{
# Create an SBS192 catalog and collapse it to an SBS96 catalog
object <- matrix(1, nrow = 192, ncol = 1, 
                 dimnames = list(catalog.row.order$SBS192))
catSBS192 <- as.catalog(object, ref.genome = "hg19", region = "transcript")
catSBS96 <- Collapse192CatalogTo96(catSBS192)
}
