% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{SplitListOfStrelkaSBSVCFs}
\alias{SplitListOfStrelkaSBSVCFs}
\title{Split a list of in-memory Strelka SBS VCF into SBS, DBS, and variants involving
> 2 consecutive bases}
\usage{
SplitListOfStrelkaSBSVCFs(
  list.of.vcfs,
  suppress.discarded.variants.warnings = TRUE
)
}
\arguments{
\item{list.of.vcfs}{A list of in-memory data frames containing Strelka SBS
VCF file contents.}

\item{suppress.discarded.variants.warnings}{Logical. Whether to suppress
warning messages showing information about the discarded variants. Default
is TRUE.}
}
\description{
SBSs are single base substitutions,
e.g. C>T, A<G,....  DBSs are double base substitutions,
e.g. CC>TT, AT>GG, ...  Variants involving > 2 consecutive
bases are rare, so this function just records them. These
would be variants such ATG>CCT, AGAT>TCTA, ...
}
\section{Value}{

A list of elements as follows:
\itemize{
\item \code{SBS.vcfs}: List of data.frames of pure SBS mutations -- no DBS or
3+BS mutations.
\item \code{DBS.vcfs}: List of data.frames of pure DBS mutations -- no SBS or
3+BS mutations.
\item \code{discarded.variants}: \strong{Non-NULL only if} there are variants
that were excluded from the analysis. See the added extra column
\code{discarded.reason} for more details.
}
}

\keyword{internal}
