# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

det2 <- function(mat, logarithm = FALSE) {
    .Call('ICAOD_det2', PACKAGE = 'ICAOD', mat, logarithm)
}

#' Fisher information matrix for the competitive inhibition Michaelis-Menten model.
#'
#' The mean velocity of the reaction rate is
#'  \deqn{\eta = \frac{VS}{Km(1 + \frac{I}{Kic} + S)}.}{\eta = (VS)/(Km(1 + I/Kic) + S).}
#'  Here,  \eqn{S} is the substrate concentration,
#'   \eqn{I} is the inhibitor concentration,
#'    \eqn{V} is the maximum velocity of the enzyme, \eqn{Kic}{K_{ic}}
#'     is the dissociation constants and \eqn{Km}{K_m} is the Michaelis-Menten constant.
#'      Any design point is of the form \eqn{(S, I)}.
#'
#' @param S vector of \code{S} component of design points. \code{S} is the substrate concentration.
#' @param I  vector of \code{I} component of design points. \code{I} is the inhibitor concentration.
#' @param w vector of corresponding weights for each design point. Its length must be equal to the length of \code{I} and \code{S}, and \code{sum(w)} should be 1.
#' @param param vector of model parameters \eqn{(V, K_m, K_{ic})}{(V, Km, Kic)}.
#' @return Fisher information matrix of design.
#' @details The model has an analytical solution for the locally D-optimal design. See Bogacka et al. (2011) for details.\cr
#' The optimal design does not depend on parameter \eqn{V}.
#' @family FIM
#' @references
#' Bogacka, B., Patan, M., Johnson, P. J., Youdim, K., & Atkinson, A. C. (2011). Optimum design of experiments for enzyme inhibition kinetic models. Journal of biopharmaceutical statistics, 21(3), 555-572.
#' @export
#'
FIM_comp_inhibition <- function(S, I, w, param) {
    .Call('ICAOD_FIM_comp_inhibition', PACKAGE = 'ICAOD', S, I, w, param)
}

#' Fisher information matrix for the three-parameter emax model.
#'
#' The mean of response variable is
#'  \deqn{f(x, \bold{\theta}) = \theta_0 + \frac{\theta_1 x}{(x + \theta_2)}}{f(x, \bold{\theta}) = \theta0 + \theta1 x/(x + \theta2)}.
#' @param x vector of design points.
#' @param w vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.
#' @param param vector of model parameters
#'  \eqn{\bold{\theta} = (\theta_0, \theta_1, \theta_2)}{\bold{\theta} =(\theta0, \theta1, \theta2)}.
#' @return Fisher information matrix.
#' @references Dette, H., Kiss, C., Bevanda, M., & Bretz, F. (2010). Optimal designs for the EMAX, log-linear and exponential models. Biometrika, 97(2), 513-518.
#' @family FIM
#' @details
#' The model has an analytical solution for the locally D-optimal design. See Dette et al. (2010) for more details.\cr
#' The Fisher information matrix does not depend on \eqn{\theta_0}{\theta0}.
#' @export
FIM_emax_3par <- function(x, w, param) {
    .Call('ICAOD_FIM_emax_3par', PACKAGE = 'ICAOD', x, w, param)
}

#' Fisher information matrix for the two-parameter exponential model.
#'
#' The mean of response variable is \deqn{f(x, \bold{\theta}) = a + \exp(-bx)}.
#' @param x vector of design points.
#' @param w vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.
#' @param param vector of model parameters \eqn{\bold{\theta} = (a, b)}.
#' @return Fisher information matrix.
#' @references Dette, H., & Neugebauer, H. M. (1997). Bayesian D-optimal designs for exponential regression models. Journal of Statistical Planning and Inference, 60(2), 331-349.
#' @family FIM
#' @details The Fisher information matrix does not depend on \code{a}.\cr
#' The locally D optimal design is independent of the nominal
#' value of \eqn{a} and is equally supported at \eqn{x = 0} and \eqn{x = 1/b}
#'  only when \eqn{x \in [0, 1]}{{x belongs to [0, 1]}}. See "Examples".
#' @export
#' @examples
#' \dontrun{
#' ### finding the locally optimal design for different values for design interval
#' mica(fimfunc = "FIM_exp_2par", lx = 0, ux = 1, lp = c(1, 2), up = c(1, 2),
#'      iter = 100, k = 2, type = "locally", control = list(seed = 215))
#'
#' mica(fimfunc = "FIM_exp_2par", lx = .0001, ux = 1, lp = c(1, 2), up = c(1, 2),
#'      iter = 100, k = 2, type = "locally", control = list(seed = 215))
#'
#' mica(fimfunc = "FIM_exp_2par", lx = 0, ux = 10, lp = c(1, 2), up = c(1, 2),
#'      iter = 100, k = 2, type = "locally", control = list(seed = 215))
#'
#' mica(fimfunc = "FIM_exp_2par", lx = .0001, ux = 10, lp = c(1, 2), up = c(1, 2),
#'      iter = 100, k = 2, type = "locally", control = list(seed = 215))
#'
#' ## it seems for design interval x = [x_l, x_u], when x_l > 0,
#' ## the locally D-optimal design is a two-point equally weighted design
#' ## with x1 = x_l, x2 = x_u
#'
#' mica(fimfunc = "FIM_exp_2par", lx = .5, ux = 10, lp = c(1, 2), up = c(1, 2),
#'      iter = 100, k = 2, type = "locally", control = list(seed = 215))
#'
#' mica(fimfunc = "FIM_exp_2par", lx = .0001, ux = 10, lp = c(1, 2), up = c(1, 2),
#'      iter = 100, k = 2, type = "locally", control = list(seed = 215))
#'
#' mica(fimfunc = "FIM_exp_2par", lx = 1, ux = 10, lp = c(1, 2), up = c(1, 2),
#'         iter = 100, k = 2, type = "locally", control = list(seed = 215))
#'
#'
#' mica(fimfunc = "FIM_exp_2par", lx = 2, ux = 10, lp = c(1, 2), up = c(1, 2),
#'      iter = 100, k = 2, type = "locally", control = list(seed = 215))
#'
#' mica(fimfunc = "FIM_exp_2par", lx = 3, ux = 9, lp = c(1, 2), up = c(1, 2),
#'      iter = 100, k = 2, type = "locally", control = list(seed = 215))
#'
#' }
FIM_exp_2par <- function(x, w, param) {
    .Call('ICAOD_FIM_exp_2par', PACKAGE = 'ICAOD', x, w, param)
}

#' Fisher information matrix for the three-parameter exponential model.
#'
#' The mean of response variable is
#'  \deqn{f(x, \bold{\theta}) = \theta_0 + \theta_1 \exp(\frac{x}{\theta_2})}{f(x, \bold{\theta}) = \theta0 + \theta1 \exp(x/\theta2)}.
#' @param x vector of design points.
#' @param w vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.
#' @param param vector of model parameters
#'  \eqn{\bold{\theta} = (\theta_0, \theta_1, \theta_2)}{\bold{\theta} =(\theta0, \theta1, \theta2)}.
#' @return Fisher information matrix.
#' @references Dette, H., Kiss, C., Bevanda, M., & Bretz, F. (2010). Optimal designs for the EMAX, log-linear and exponential models. Biometrika, 97(2), 513-518.
#' @family FIM
#' @details
#' The model has an analytical solution for the locally D-optimal design. See Dette et al. (2010) for more details.\cr
#' The Fisher information matrix does not depend on \eqn{\theta_0}{\theta0}.
#' @export
FIM_exp_3par <- function(x, w, param) {
    .Call('ICAOD_FIM_exp_3par', PACKAGE = 'ICAOD', x, w, param)
}

#' Fisher information matrix for the one-parameter logistic model (1PL or Rasch model).
#'
#' The mean of response variable is
#'  \deqn{f(x, a) = 1/(1 + \exp(-(x - a))).}{f(x, a) = \frac{1}{(1 + exp(-(x - a)))}.}
#'  This function returns Fisher information for the design \eqn{\xi} that is
#'  \deqn{M(\xi; a) = \sum_{i = 1}^kw_iM(x_i, a).}{M(\xi, a) = sum w_i M(x_i, a).}
#'   Here \eqn{M(x, a)}  is \eqn{g(x-a)}, where
#'  \eqn{g(z) = \frac{\exp(z)}{(1 + \exp(z))^2}}{g(z) = exp(z)/(1 + exp(z))^2}.
#'  denotes the standard logistic density.
#'
#' @param x vector of design points. In IRT \code{x} is the person ability parameter.
#' @param w vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.
#' @param param parameter \eqn{a}. In IRT, it is called difficulty parameter.
#' @return Fisher information as a one by one matrix.
#' @references
#' Grasshoff, U., Holling, H., & Schwabe, R. (2012). Optimal designs for the Rasch model. Psychometrika, 77(4), 710-723.
#' @details
#' The locally optimal design is a one point design with \eqn{x^* = a}{x* = a} and provides a value of
#' \eqn{M(\xi^*, a) =  1/4}{M(\xi*, a) =  1/4} for the information.
#' @family FIM
#' @export
FIM_logisitic_1par <- function(x, w, param) {
    .Call('ICAOD_FIM_logisitic_1par', PACKAGE = 'ICAOD', x, w, param)
}

#' Fisher information matrix for the four parameter logistic model.
#'
#' The mean of the response variable is
#'  \deqn{f(x, \bold{\theta}) = \frac{\theta_1}{1 + \exp(\theta_2 x + \theta_3)} + \theta_4,}{
#'  f(x, \bold{\theta})= \theta1/(1 + exp(\theta2*x + \theta3)) + \theta4,}
#'   where \eqn{\bold{\theta} = (\theta_1, \theta_2, \theta_3, \theta_4)}{\bold{\theta} = (\theta1, \theta2, \theta3, \theta4)}.
#' @param x vector of design points.
#' @param w vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.
#' @param param vector of model parameters
#'  \eqn{\bold{\theta} = (\theta_1, \theta_2, \theta_3, \theta_4)}{\bold{\theta} = (\theta1, \theta2, \theta3, \theta4)}.
#' @return Fisher information matrix.
#' @details The fisher information matrix does not depend on \eqn{\theta_4}{\theta4}.\cr
#' There is no analytical solution for the locally D-optimal design for this model.
#' @family FIM
#' @export
FIM_logistic_4par <- function(x, w, param) {
    .Call('ICAOD_FIM_logistic_4par', PACKAGE = 'ICAOD', x, w, param)
}

#' Fisher information matrix for the two-parameter logistic (2PL) model.
#'
#' The mean of response variable is \deqn{f(x, \bold{\theta}) = \frac{1}{(1 + \exp(-b (x - a)))},}{f(x, \bold{\theta}) = 1/(1 + \exp(-b (x - a))),} where
#' \eqn{\bold{\theta} = (a, b)}.
#' @param x vector of design points. In IRT, \eqn{x} is the person ability parameter.
#' @param w vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.
#' @param param vector of model parameters \eqn{\bold{\theta} = (a, b)}. In IRT parameter
#' \eqn{a} is the item difficulty parameter and parameter \eqn{b} is the item discrimination parameter.
#' @return Fisher information matrix.
#' @family FIM
#' @export
#' @details
#' There is no closed-form for the locally optimal design.
#'  For minimax and standardized D-optimal design, the optimal design is symmetric around point
#' \eqn{(a^L + a^U)/2}{(aL + aU)/2} where \eqn{a^L}{aL} and \eqn{a^U}{aU} are the
#' lower bound and upper bound for parameter \eqn{a}, respectively. In \code{\link{mica}},
#'  options \code{sym} and \code{sym_point} in \code{control} can be used to make the search
#'   for the optimal design easier.
#'
#' @importFrom Rcpp evalCpp
#' @useDynLib ICAOD
FIM_logistic <- function(x, w, param) {
    .Call('ICAOD_FIM_logistic', PACKAGE = 'ICAOD', x, w, param)
}

#' Fisher information matrix for the log-linear model.
#'
#' The mean of response variable is
#'  \deqn{f(x, \bold{\theta}) = \theta_0 + \theta_1\log(x + \theta_2)}{f(x, \bold{\theta}) = \theta0 + \theta1\log(x + \theta2)}.
#'
#'
#' @param x vector of design points.
#' @param w vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.
#' @param param vector of model parameters
#'  \eqn{\bold{\theta} = (\theta_0, \theta_1, \theta_2)}{\bold{\theta} =(\theta0, \theta1, \theta2)}.
#' @return Fisher information matrix.
#' @references Dette, H., Kiss, C., Bevanda, M., & Bretz, F. (2010). Optimal designs for the EMAX, log-linear and exponential models. Biometrika, 97(2), 513-518.
#' @family FIM
#' @details
#' The model has an analytical solution for the locally D-optimal design. See Dette et al. (2010) for more details.\cr
#' The Fisher information matrix does not depend on \eqn{\theta_0}{\theta0}.
#' @export
FIM_loglin <- function(x, w, param) {
    .Call('ICAOD_FIM_loglin', PACKAGE = 'ICAOD', x, w, param)
}

#' Fisher information matrix for the Michaelis-Menten model.
#'
#' The mean of the response variable is
#'  \deqn{f(x, \bold{\theta}) = \frac{ax}{(b + x)},}{f(x, \bold{\theta}) = ax/(b + x),}
#'  where \eqn{\bold{\theta} = (a, b)}.
#' @param x vector of design points.
#' @param w vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.
#' @param param vector of model parameters \eqn{\bold{\theta} = (a, b)}.
#' @return Fisher information matrix.
#' @references Rasch, D. (1990). Optimum experimental design in nonlinear regression. Communications in Statistics-Theory and Methods, 19(12), 4786-4806.
#' @details
#' There is an analytical solution for the locally D-optimal design. See Rasch (1990).
#' @family FIM
#' @export
FIM_michaelis <- function(x, w, param) {
    .Call('ICAOD_FIM_michaelis', PACKAGE = 'ICAOD', x, w, param)
}

#' Fisher information matrix for the mixed inhibition Michaelis-Menten model.
#'
#' The mean velocity of the reaction rate is
#' \deqn{\eta = \frac{VS}{K_m(1 + \frac{I}{Kic}) + S(1 + \frac{I}{Kiu})}.}{\eta = VS/(K_m(1 + I/Kic) + S(1 + I/Kiu)).}
#'  Here, \eqn{S} is the substrate concentration, \eqn{I} is the inhibitor concentration,
#'   \eqn{V} is the maximum velocity of the enzyme, \eqn{K_{ic}}{Kic} and
#'    \eqn{K_{iu}}{Kiu} are the dissociation constants and \eqn{K_m}{Km} is
#'     the Michaelis-Menten constant. Any design point is of the form \eqn{(S, I)}.
#'
#'
#' @param S vector of \code{S} component of design points. \code{S} is the substrate concentration.
#' @param I  vector of \code{I} component of design points. \code{I} is the inhibitor concentration.
#' @param w vector of corresponding weights for each design point. Its length must be equal to the length of \code{I} and \code{S}, and \code{sum(w)} should be 1.
#' @param param vector of model parameters \eqn{(V, K_m, K_{ic}, K_{iu})}{(V, Km, Kic, Kiu)}.
#' @return Fisher information matrix of design.
#' @references Bogacka, B., Patan, M., Johnson, P. J., Youdim, K., & Atkinson, A. C. (2011). Optimum design of experiments for enzyme inhibition kinetic models. Journal of biopharmaceutical statistics, 21(3), 555-572.
#' @family FIM
#' @details The model has an analytical solution for the locally D-optimal design. See Bogacka et al. (2011) for details.\cr
#' The optimal design does not depend on parameter \eqn{V}.
#' @export
FIM_mixed_inhibition <- function(S, I, w, param) {
    .Call('ICAOD_FIM_mixed_inhibition', PACKAGE = 'ICAOD', S, I, w, param)
}

#' Fisher information matrix for the noncompetitive inhibition Michaelis-Menten model.
#'
#' The mean velocity of the reaction rate is
#'  \deqn{\eta = \frac{VS}{(K_m + S)(1 + \frac{I}{K_{ic}})}.}{\eta = VS/(Km + S)(1 + I/Kic).}
#'   Here, \eqn{S} is the substrate concentration, \eqn{I} is the inhibitor concentration,
#'    \eqn{V} is the maximum velocity of the enzyme,
#'     \eqn{K_{ic}}{Kic} is the dissociation constants and \eqn{K_m}{Km} is the Michaelis-Menten constant.
#'      Any design point is of the form \eqn{(S, I)}.
#' @param S vector of \code{S} component of design points. \code{S} is the substrate concentration.
#' @param I  vector of \code{I} component of design points. \code{I} is the inhibitor concentration.
#' @param w vector of corresponding weights for each design point. Its length must be equal to the length of \code{I} and \code{S}, and \code{sum(w)} should be 1.
#' @param param vector of model parameters \eqn{(V, K_m, K_{ic})}{(V, Km, Kic)}.
#' @return Fisher information matrix.
#' @references Bogacka, B., Patan, M., Johnson, P. J., Youdim, K., & Atkinson, A. C. (2011). Optimum design of experiments for enzyme inhibition kinetic models. Journal of biopharmaceutical statistics, 21(3), 555-572.
#' @details The model has an analytical solution for the locally D-optimal design. See Bogacka et al. (2011) for details.\cr
#' The optimal design does not depend on parameter \eqn{V}.
#' @family FIM
#' @export
FIM_noncomp_inhibition <- function(S, I, w, param) {
    .Call('ICAOD_FIM_noncomp_inhibition', PACKAGE = 'ICAOD', S, I, w, param)
}

#' Fisher information matrix for the power logistic model.
#'
#' The mean of response variable is
#'  \deqn{f(x; a, b, s) =  \frac{1}{(1 + \exp(-b (x - a)))^s},}{f(x; a, b, s) =  1/(1 + \exp(-b (x - a)))^s,}
#' @param x vector of design points.
#' @param w vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.
#' @param param vector of model parameters \eqn{(a, b)}.
#' @param s power parameter.
#' @return Fisher information matrix.
#' @details
#' There is no analytical solution for the locally D-optimal design. Parameter \eqn{s} must be
#' passed by \code{...} in most of the functions like \code{\link{mica}}.
#' @family FIM
#' @export
FIM_power_logistic <- function(x, w, param, s) {
    .Call('ICAOD_FIM_power_logistic', PACKAGE = 'ICAOD', x, w, param, s)
}

#' Fisher information matrix for the uncompetitive inhibition Michaelis-Menten model.
#'
#' The mean velocity of the reaction rate is
#'  \deqn{\eta =  \frac{VS}{(K_m + S(1 + \frac{I}{K_{iu}}))}.}{\eta =  VS/(Km + S(1 + I/Kiu)).}
#'  Here, \eqn{S} is the substrate concentration, \eqn{I} is the inhibitor concentration,
#'   \eqn{V} is the maximum velocity of the enzyme, \eqn{K_{iu}}{Kiu} is the dissociation constants and
#'    \eqn{K_m}{Km} is the Michaelis-Menten constant. Any design point is of the form \eqn{(S, I)}.
#' @param S vector of \code{S} component of design points. \code{S} is the substrate concentration.
#' @param I  vector of \code{I} component of design points. \code{I} is the inhibitor concentration.
#' @param w vector of corresponding weights for each design point.
#'  Its length must be equal to the length of \code{I} and \code{S}, and \code{sum(w)} should be 1.
#' @param param vector of model parameters \eqn{(V, K_m, K_{iu})}{(V, Km, Kiu)}.
#' @return Fisher information matrix.
#' @references Bogacka, B., Patan, M., Johnson, P. J., Youdim, K., & Atkinson, A. C. (2011). Optimum design of experiments for enzyme inhibition kinetic models. Journal of biopharmaceutical statistics, 21(3), 555-572.
#' @details The model has an analytical solution for the locally D-optimal design. See Bogacka et al. (2011) for details.\cr
#' The optimal design does not depend on parameter \eqn{V}.
#' @family FIM
#' @export
FIM_uncomp_inhibition <- function(S, I, w, param) {
    .Call('ICAOD_FIM_uncomp_inhibition', PACKAGE = 'ICAOD', S, I, w, param)
}

