% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{icd_meta_transition}
\alias{icd_meta_transition}
\title{data.frame detailling the changes in ICD-10-GM codes between versions}
\format{
An object of class \code{data.frame} with 228848 rows and 12 columns.
}
\source{
The source data was downloaded from the official download centre
of the German Institute for Medical Documentation and Information (DIMDI).
See also \url{https://www.dimdi.de/dynamic/en/classifications/icd/icd-10-gm/tabular-list/#crosswalks}
}
\usage{
icd_meta_transition
}
\description{
A data.frame providing old and new ICD codes
(identical if no changes)
and information as to whether the transition is automatic when
transitioning forwards or backwards
}
\details{
\describe{
\item{year_from}{Year of validity of the old code (from 2004)}
\item{year_to}{Year of validity of the new code (from 2005)}
\item{icd_from}{Old ICD code}
\item{icd_to}{New ICD code}
\item{automatic_forward}{Whether the transition is automatic in the forward direction (i.e. the old code can always be converted to the new code). (A: automatic, otherwise NA)}
\item{automatic_backward}{Whether the transition is automatic in the forward direction (i.e. the new code can always be converted to the old code) (A: automatic, otherwise NA)}
\item{change_5}{Whether the change relates to the fifth digit of the ICD-10 code (TRUE/FALSE).}
\item{change_4}{Whether the change relates to the fourth digit of the ICD-10 code (TRUE/FALSE).}
\item{change_3}{Whether the change relates to the three-digit ICD-10 code (TRUE/FALSE).}
\item{icd3}{The first three digits of \code{icd_from}.}
\item{icd_chapter}{The first character of \code{icd_from} (i.e. the letter denoting the chapter).}
}
}
\seealso{
Other ICD-10-GM metadata: 
\code{\link{icd_meta_blocks}},
\code{\link{icd_meta_chapters}},
\code{\link{icd_meta_codes}}
}
\concept{ICD-10-GM metadata}
\keyword{datasets}
