% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getp.R
\name{getExpp}
\alias{getExpp}
\title{getExpp}
\usage{
getExpp(exp_data, label, p.adjust = TRUE, method = "fdr")
}
\arguments{
\item{exp_data}{A data frame, the expression profile to calculate p-value for each gene, the rownames should be the symbol of genes.}

\item{label}{A vector of 0/1s, indicating the class of samples in the expression profile, 0 represents case, 1 represents control.}

\item{p.adjust}{Logical,tell if returns corrected p-values}

\item{method}{Correction method,which can be one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY",}
}
\value{
A numeric vector of p-values or corrected p-values
}
\description{
`getExpp` perform t-test on Expression profile data
}
\details{
For a given expression profile of two conditions, ICDS package provide t-test method to calculate p-values or corrected p-values(if p.adjust=TRUE,return corrected p-values,if p.adjust=FALSE,return p-values.) for each genes. The row of the expression profile should be gene symbols and the column of the expression profile should be names of samples. Samples should be under two conditions and the label should be given as 0 and 1.
}
\examples{
profile<-GetExampleData("exp_data")
label<-GetExampleData("label1")
getExpp(profile,label,p.adjust=FALSE)
}
