% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcCoxCalibP.R
\name{CalcCoxCalibP}
\alias{CalcCoxCalibP}
\title{Calculating the probabilities of positive binary exposure status at a given time point using a proportional hazards calibration model}
\usage{
CalcCoxCalibP(w, w.res, point, fit.cox, hz.times, Q)
}
\arguments{
\item{w}{A matrix of time points when measurements on the binary covariate were obtained.}

\item{w.res}{A matrix of measurement results of the binary covariate. Each measurement corresponds to the time points in \code{w}}

\item{point}{The time point at which the probabilities are estimated}

\item{fit.cox}{The result of \code{icenReg::ic_sp} on the interval-censored data}

\item{hz.times}{Times used for calculating the baseline hazard function from PH calibration model}

\item{Q}{Matrix of covariates for the PH calibration model}
}
\value{
A vector of estimated probabilities of positive exposure status at time \code{point}.
}
\description{
For a given time point, calculate the probability of positive exposure value  for multiple observations (participants). 
The function uses the results of a proportional hazards calibration model fit, and given covariates and collected data on the history 
of the binary exposure for each participant.
}
\examples{
sim.data <- ICcalib:::SimCoxIntervalCensCox(n.sample = 200, lambda = 0.1, 
                                            alpha = 0.25, beta0 = 0, 
                                            gamma.q = c(log(0.75), log(2.5)), 
                                            gamma.z = log(1.5), mu = 0.2, 
                                            n.points = 2)
# The baseline hazard for the calibration model is calculated in observation times
cox.hz.times <- sort(unique(sim.data$obs.tm)) 
# Fit proprtional hazards calibration model
fit.cox <- FitCalibCox(w = sim.data$w, w.res = sim.data$w.res, Q = sim.data$Q, 
                       hz.times = cox.hz.times, n.int = 5, order = 2)
# Calculate the conditional probabilities of binary covariate=1 at time one
probs <- CalcCoxCalibP(w = sim.data$w, w.res = sim.data$w.res, point = 1,
                       Q = sim.data$Q, fit.cox = fit.cox, hz.times = cox.hz.times)
summary(probs)
}
