% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDF.R
\name{IDF.fit}
\alias{IDF.fit}
\title{Fitting IDF model parameters to observations at different durations}
\usage{
IDF.fit(data, agg.lev = c(2, 3, 6, 12, 24, 48, 72, 96), month = "all",
  moving.sum = "FALSE", theta.init = 0, use.log = FALSE, DEBUG = FALSE,
  method = "Nelder-Mead", upper = Inf, lower = -Inf, plot = FALSE,
  probs = c(0.5, 0.9, 0.99), cols = c(rgb(1, 0, 0, 1), rgb(0, 1, 0, 1),
  rgb(0, 0, 1, 1)), station.name = "Berlin", data.name = "obs")
}
\arguments{
\item{data}{a \code{data,frame}, preferably generated by function \code{IDF.read}. It should at least contain a \code{$RR} and \code{$year} element for the 
function tow work properly.}

\item{agg.lev}{a vector of aggregation levels used to fit the IDF curves.}

\item{month}{\code{integer} value specifying the month to be used for estimating the IDF parameters. Type "all" for all months or if
the whole time series should be fitted.}

\item{moving.sum}{\code{logical} specifying if moving sum filtering should be applied for time series aggregation.}

\item{theta.init}{inital value defining the curvature of the IDF, default is zero, it is not recommended to change it}

\item{use.log}{\code{logical} value for usage of logarithmic values, default is \code{FALSE}}

\item{DEBUG}{\code{logical} value for usage of debugging, if \code{TRUE} the input parameters and the value of negative}

\item{method}{\code{character} defining the method to be used in \code{optim}, preferences are: "Nelder-Mead", "BFGS", "L-BFGS-B"e}

\item{upper}{\code{vector} specifying the upper boundary of parameters for "L-BFGS-B" method}

\item{lower}{\code{vector} specifying the lower boundary of parameters for "L-BFGS-B" method}

\item{plot}{\code{logical} option of creating a plot of IDF curves with estimated parameters.}

\item{probs}{a vector of probabilities for which the IDF curves are calculated}

\item{cols}{a vector of colors for the seperate IDF curves, needs same length as \code{probs}}

\item{station.name}{\code{character} overall naming of the IDF plot, e.g. name of location or model name}

\item{data.name}{\code{character} naming the data points, e.g. obs or model name}
}
\value{
$ints vector of sorted intensities for selected aggregation levels

$durs vector of sorted aggregation levels

$min minimum value of negative log-likelihood during optimization

$par vector of estimated IDF model parameters mu,sigma,xi,theta,eta at minimum value of negative log-likelihood.
}
\description{
The function \code{IDF.fit} fits the IDF model parameters \code{mu,sigma,xi,eta,theta}
to a data.frame of observations \code{data} with temporal inforamtion (at least years) and values of precipitation
at a given temporal resoultion. This precipitation time series gets aggregated at given aggregation levels.
\code{agg.lev} and yearly maxima of intensity are caluclated for a specific month or the whole year/dataset. 
The starting values of the IDF model parameters can be determined by the user as well as specific options to use
during optimization. Logartihmic transformation, debugging, the optimization method, and an option to plot the
IDF curves.
}
\examples{
RR <- rgamma(10*30*24,shape=1)
year <- sort(rep(1:(10),30*24))
data <- data.frame(RR,year)
fit <- IDF.fit(data)
pars <- fit$par 
}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}

