% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gevdfit.R
\name{gev.d.diag}
\alias{gev.d.diag}
\title{Diagnostic Plots for d-gev Models}
\usage{
gev.d.diag(
  fit,
  subset = NULL,
  cols = NULL,
  pch = NULL,
  which = "both",
  mfrow = c(1, 2),
  legend = TRUE,
  title = c("Residual Probability Plot", "Residual Quantile Plot"),
  emp.lab = "Empirical",
  mod.lab = "Model",
  ...
)
}
\arguments{
\item{fit}{object returned by \code{\link{gev.d.fit}}}

\item{subset}{an optional vector specifying a subset of observations to be used in the plot}

\item{cols}{optional either one value or vector of same length as \code{unique(fit$ds)} to
specify the colors of plotting points.
The default uses the \code{rainbow} function.}

\item{pch}{optional either one value or vector of same length as \code{unique(fit$ds)} containing
integers or symbols to specify the plotting points.}

\item{which}{string containing 'both', 'pp' or 'qq' to specify, which plots should be produced.}

\item{mfrow}{vector specifying layout of plots. If both plots should be produced separately,
set to \code{c(1,1)}.}

\item{legend}{logical indicating if legends should be plotted}

\item{title}{character vector of length 2, giving the titles for the pp- and the qq-plot}

\item{emp.lab, mod.lab}{character string containing names for empirical and model axis}

\item{...}{additional parameters passed on to the plotting function}
}
\description{
Produces diagnostic plots for d-gev models using
the output of the function \code{\link{gev.d.fit}}. Values for different durations can be plotted in
different colors of with different symbols.
}
\examples{
data('example',package ='IDF')

fit <- gev.d.fit(xdat=example$dat,ds = example$d,ydat=as.matrix(example[,c('cov1','cov2')])
                 ,mutl=c(1,2),sigma0l=1)
# diagnostic plots for complete data
gev.d.diag(fit,pch=1)
# diagnostic plots for subset of data (e.g. one station)
gev.d.diag(fit,subset = example$cov1==1,pch=1)
}
