% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get.theta.ci}
\alias{get.theta.ci}
\title{Calculate bootstrapped confidence intervals for \code{get.theta} values.}
\usage{
get.theta.ci(posmat, fun, r = 1, r.low = rep(0, length(r)),
  boot.iter = 1000, ci.low = 0.025, ci.high = 0.975)
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{fun}{the function to decide relationships}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range. 0 by default}

\item{boot.iter}{the number of bootstrap iterations}

\item{ci.low}{the low end of the ci...0.025 by default}

\item{ci.high}{the high end of the ci...0.975 by default}
}
\value{
a matrix with a row for the high and low values and
    a column per distance
}
\description{
Wrapper to \code{get.theta.bootstrap} that takes care of calculating the
confience intervals based on the bootstrapped values.
}
\examples{
\dontrun{
 R/examples/get_theta_ci.R
 }
}
\author{
Justin Lessler
}
\seealso{
Other get.theta: \code{\link{get.theta.bootstrap}};
  \code{\link{get.theta.permute}};
  \code{\link{get.theta.typed.bootstrap}};
  \code{\link{get.theta.typed.permute}};
  \code{\link{get.theta.typed}}; \code{\link{get.theta}}
}

