% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.pi.bootstrap}
\alias{get.pi.bootstrap}
\title{Bootstrap \code{get.pi} values.}
\usage{
get.pi.bootstrap(posmat, fun, r = 1, r.low = rep(0, length(r)),
  boot.iter = 500)
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{fun}{the function to decide relationships}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range. 0 by default}

\item{boot.iter}{the number of bootstrap iterations}
}
\value{
pi values for all the distances we looked at
}
\description{
Runs \code{get.pi} on multiple bootstraps of the data. Is formulated
such that the relationships between
points and themselves will not be calculated.
}
\note{
In each bootstrap iteration N observations are drawn from the existing data with replacement. To avoid errors in
inference resulting from the same observatin being compared with itself in the bootstrapped data set, original indices
are perserved, and pairs of points in the bootstrapped dataset with the same original index are ignored.
}
\examples{
\dontrun{
 R/examples/get_pi_bootstrap.R
 }

}
\seealso{
Other get.pi: \code{\link{get.pi.ci}},
  \code{\link{get.pi.permute}},
  \code{\link{get.pi.typed.bootstrap}},
  \code{\link{get.pi.typed.permute}},
  \code{\link{get.pi.typed}}, \code{\link{get.pi}}
}
\author{
Justin Lessler and Henrik Salje
}
