% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Butterfly.R
\name{Butterfly}
\alias{Butterfly}
\title{Butterfly Data Set Generator}
\usage{
Butterfly(N=10000)
}
\arguments{
\item{N}{The number of points to be generated.}
}
\value{
A \eqn{N \times 9}{N x 9} data frame. The first eight columns are the input variables
and the last one is the output (or target) variable.
}
\description{
Generates the butterfly data set with a given number of points.
}
\examples{
N <- 1000
bf <- Butterfly(N)

\dontrun{
require(colorRamps)
require(rgl)

c <- cut(bf$Y,breaks=64)
cols <- matlab.like(64)[as.numeric(c)]

plot3d(bf$X1,bf$X2,bf$Y,col=cols,radius=0.10,type="s",
       xlab="",ylab="",zlab="",box=F)
axes3d(lwd=3,cex.axis=3)
grid3d(c("x+","y-","z"),col="black",lwd=1)
}
}
\author{
Jean Golay \email{Jean.Golay@unil.ch}
}
\references{
J. Golay, M. Leuenberger and M. Kanevski (2016). Feature Selection for Regression Problems Based
on the Morisita Estimator of Intrinsic Dimension, \href{https://arxiv.org/abs/1602.00216}{arXiv:1602.00216}.
}

