% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_rm_features.R
\name{data_rm_features}
\alias{data_rm_features}
\title{Remove Features from an IFC_data Object}
\usage{
data_rm_features(obj, features, list_only = TRUE, ...)
}
\arguments{
\item{obj}{an `IFC_data` object extracted by ExtractFromDAF(extract_features = TRUE) or ExtractFromXIF(extract_features = TRUE).}

\item{features}{a character vector of features names to remove within 'obj'. Note that "Object Number" is not allowed and will be excluded from 'features' if present.}

\item{list_only}{whether to return a list of elements that will be impacted by the removal. Default is TRUE.
If FALSE then modified object will be returned}

\item{...}{Other arguments to be passed.}
}
\value{
an `IFC_data` object or a list of elements impacted by removal depending on 'list_only' parameter.
}
\description{
Removes regions from an already existing `IFC_data` object.
}
