% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seed.R
\name{with_seed}
\alias{with_seed}
\title{With Seed Evaluation}
\usage{
with_seed(
  expr,
  seed = NA_integer_,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL
)
}
\arguments{
\item{expr}{expression to evaluate.}

\item{seed}{a single value, interpreted as an integer, or NULL, with the exception that NA can be provided to prevent passing 'seed' argument. Default is NA_integer_.}

\item{kind}{character or NULL. If kind is a character string, set R's RNG to the kind desired. Use "default" to return to the R default.}

\item{normal.kind}{character string or NULL. If it is a character string, set the method of Normal generation. Use "default" to return to the R default. NULL makes no change.}

\item{sample.kind}{character string or NULL. If it is a character string, set the method of discrete uniform generation (used in sample, for instance). Use "default" to return to the R default. NULL makes no change. Only applies on R version >= 3.6.0.}
}
\description{
Evaluates expression with a seed and resets to initial seed state on exit
}
\details{
see ‘Details’, from  \link[base]{set.seed}, with the exception of 'seed'. Using seed = NA_integer_, NOTHING will be passed to \link[base]{set.seed} nor \link[base]{RNGkind} and NOTHING will be restored once done.
Otherwise, \link[base]{set.seed} will be used and once done \link[base]{RNGkind} will be restored and ".Random.seed" from \link[base]{globalenv} set back to its initial value (included removed if it did not exist).
}
\keyword{internal}
