% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wages_inversion.R
\name{wages_inversion}
\alias{wages_inversion}
\title{Function to compute equilibrium wages that make the model labor in every
location in equal to the observed data. It finds the w's
such that equation (3.2) holds.}
\usage{
wages_inversion(
  N,
  w_init,
  theta,
  tau,
  L_i,
  L_j,
  nu_init = 0.05,
  tol = 10^-10,
  maxiter = 10000
)
}
\arguments{
\item{N}{Integer - Number of locations.}

\item{w_init}{Initial vector of wages.}

\item{theta}{Float - Commuting elasticity.}

\item{tau}{NxN matrix - Commuting cost matrix across all locations.}

\item{L_i}{Nx1 matrix - Number of residents in each location.}

\item{L_j}{Nx1 matrix - Number of workers in each location.}

\item{nu_init}{Float - Convergence parameter to update wages.
Default nu=0.01.}

\item{tol}{Float - Maximum tolerable error for estimating total labor.
Default tol=10^-10.}

\item{maxiter}{Integer - Maximum number of iterations for convergence.
Default maxiter=10000.}
}
\value{
A list with equilibrium wages and probability of workers in each
location working in every other location.
}
\description{
Function to compute equilibrium wages that make the model labor in every
location in equal to the observed data. It finds the w's
such that equation (3.2) holds.
}
