% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IGP_S3.R
\name{predict.IGP}
\alias{predict.IGP}
\title{Predict for class IGP}
\usage{
\method{predict}{IGP}(object, XX, se.fit = FALSE, ...)
}
\arguments{
\item{object}{Object of class IGP}

\item{XX}{Points to predict at}

\item{se.fit}{Whether the standard error prediction should be returned with the mean prediction}

\item{...}{Additional parameters}
}
\value{
Prediction from object at XX
}
\description{
Predict for class IGP
}
\examples{
n <- 12
x <- matrix(seq(0,1,length.out = n), ncol=1)
y <- sin(2*pi*x) + rnorm(n,0,1e-1)
gp <- IGP(package='laGP', X=x, Z=y, parallel=FALSE)
predict(gp, .448)
}
