% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simHawkes.R
\name{simoffspring}
\alias{simoffspring}
\title{Simulate the offspring events
\code{simoffspring} simulates the birth times of offspring events
of all generations spawned from an event relative the birth time of
the parent event. This function is to be called by the simulator
function for Hawkes processes and is not meant for external use.}
\usage{
simoffspring(br = 0.5, dis = "exp", par.dis = list(rate = 1))
}
\arguments{
\item{br}{numerical scalar in [0,1), the branching ratio, or the
expected number of direct children due to an event}

\item{dis, }{character string, which gives the name of the common
(positive) distribution of the birth times of the child events
relative to the parent event (referred to as the child
birthtime distribution), such as "exp", "gamma", "weibull",
etc.}

\item{par.dis, }{list, which gives the values of the (named)
parameter(s) of the child birthtime distribution)}
}
\value{
a numeric vector of giving the birth times of offspring
    events of all generations relative to the parent's birth time
    in ascending order
}
\description{
Simulate the offspring events
\code{simoffspring} simulates the birth times of offspring events
of all generations spawned from an event relative the birth time of
the parent event. This function is to be called by the simulator
function for Hawkes processes and is not meant for external use.
}
\details{
This function uses recursion, so can break down when the
    branching ratio is close to 1, leading to very deep
    recursions. In this case, we should use \code{simHawkes1} for
    Hawkes process simulation.
}
\examples{
  simoffspring(br=0.9,dis="exp",par.dis=list(rate=1))
}
\seealso{
\code{\link{simchildren}}
}
