% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab.fqcs.R
\name{lab.fqcs}
\alias{lab.fqcs}
\alias{lab.fqcs.default}
\alias{lab.fqcs.lab.fqcd}
\alias{print.lab.fqcs}
\alias{summary.lab.fqcs}
\title{It developes an object of class 'lab.fqcs'}
\usage{
lab.fqcs(x, ...)

\method{lab.fqcs}{default}(x, argvals = NULL, rangeval = NULL, ...)

\method{lab.fqcs}{lab.fqcd}(x, ...)

\method{print}{lab.fqcs}(x, ...)

\method{summary}{lab.fqcs}(object, ...)
}
\arguments{
\item{x}{A \code{lab.fqcs} object for which a print is desired.}

\item{...}{Arguments passed to or from methods.}

\item{argvals}{Argvals, by default: 1:p.}

\item{rangeval}{Range of discretization points, by default: range(argvals).}

\item{object}{A \code{lab.fqcs} object for which a summary is desired.}
}
\description{
Create an object of class 'lab.fqcs' to perform statistical quality control. 
This function is used to compute requested FDA.
}
\examples{
\dontrun{
library(ILS)
data(TG)
delta <- seq(from = 40 ,to = 850 ,length.out = 1000 )
curves.fqcd <- lab.fqcd(TG, argvals = delta)
p <- curves.fqcd$p
curves.fqcs <- lab.fqcs(curves.fqcd)
summary(curves.fqcs)
names(curves.fqcs)

##### Statistical Functional
windows(20,10)
xlab <- "Temperature (C)"
ylab <- "Mass (\%)"
main <- "Statistical Functional"
col <- 1:p
}
}
\references{
\describe{
  \item{}{Febrero-Bande, M. and Oviedo, M. (2012),
   "Statistical computing in functional data analysis: the R package fda.usc". Journal of Statistical Software 51 (4), 1-28.}
  \item{}{Cuevas A., Febrero-Bande, M. and Fraiman, R. (2006), "On the use of the bootstrap for estimating functions with functional data". 
  Computational Statistics & Data Analysis 51, 2, 1063-1074. }
  \item{}{Naya, S., Tarrio-Saavedra. J., Lopez- Beceiro, J., Francisco Fernandez, M., Flores, M. and  Artiaga, R. (2014), 
  "Statistical functional approach for interlaboratory studies with thermal data". Journal of Thermal Analysis and Calorimetry, 118,1229-1243.}
}
}

