% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hc.R
\name{Hc}
\alias{Hc}
\title{Counting the degree hub of multilayer network}
\usage{
Hc(network.or.subnet_mat1, subnet_mat2 = NULL)
}
\arguments{
\item{network.or.subnet_mat1}{Either a multilayer(tripartite) network of 'igraph' class which contains interlayer links and without intralayer links, or a numeric matrix(or data.frame) representing interactions between two groups of species.
Each row and column of matrix represents single species in the second and first groups of the tripartite network respectively.
Elements of matrix are non-zero numbers if the two groups of species are connected, and 0 otherwise.}

\item{subnet_mat2}{A numeric matrix(or data.frame) representing interactions between two groups of species.
Each row and column of matrix represents single species in the second and third groups of the tripartite network respectively.
Elements of matrix are non-zero numbers if the two groups of species are connected, and 0 otherwise. If \code{network.or.subnet_mat1} is "igraph", \code{subnet_mat2} defaults to NULL.}
}
\value{
Print a "Hc= ;" and Return a numeric value representing the degree hub of network.
}
\description{
This function counts degree hub that the proportion of interconnecting species serving as the core node of the network degree.
}
\details{
\strong{network.or.subnet_mat1} and \strong{subnet_mat2}

There are two types of \code{network.or.subnet_mat1} that can be processed:
\itemize{
\item{(1). Input in a network of type "igraph" alone.}
\item{(2). Must be entered as data frame or matrix with \code{subnet_mat2}.}
}

If the type of inputting is data frame or matrix, please make sure the row of \code{network.or.subnet_mat1} and \code{subnet_mat2} correspond with the second group of species that both belong to two subnetworks and interact with other groups of species.
\itemize{
\item{Try to make the rows of both matrices have the same attributes. Or we default:}
\item{(1). If both matrices have row names, then the function counts all row names to produce two new matrices with the same row names.}
\item{(2). If at most one matrix has row names, the function assigns new row names to both matrices on a row-to-row basis (any extra row names are assigned a new value) and then counts all row names to produce two new matrices with the same row names.}
\item{The two matrices can have different numbers of rows, but read our default handling carefully to make sure the calculation is accurate when using this function!!!}
}

About a network of type "igraph", It can be obtained from the connection matrices of subnetworks by the function \code{igraph_from_matrices}.
}
\examples{

set.seed(15)
d <- build_net(11,15,17,0.2)
Hc(d)

md1<-matrix(sample(c(0,1),80,replace=TRUE),8,10)
md2<-matrix(sample(c(0,1),120,replace=TRUE),10,12)
Hc(md1,md2)

mdw1<-matrix(sample(c(rep(0,60),runif(60,0,1))),12,10)
mdw2<-matrix(sample(c(rep(0,40),runif(80,0,1))),10,12)
Hc(mdw1,mdw2)

}
\references{
Domínguez-García, V., & Kéfi, S. (2021). The structure and robustness of tripartite ecological networks. bioRxiv, 2021-10.
}
