% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMAGE.R
\name{image}
\alias{image}
\title{High-powered detection of genetic effects on DNA methylation}
\usage{
image(geno, data, K, Covariates = NULL, numCore = 1,
  fit.maxiter = 500, fit.tol = 1e-05, verbose = TRUE)
}
\arguments{
\item{geno}{a data list containing the genotype data}

\item{data}{a data list containing the methylation data}

\item{K}{a known kinship matrix. This matrix should be a positive semi-definite
matrix with dimensions equal to the sample size}

\item{Covariates}{a matrix containing the covariates subject to adjustment (Default = NULL)}

\item{numCore}{a positive integer specifying the number of cores for parallel computing (default = 1)}

\item{fit.maxiter}{a positive integer specifying the maximum number of iterations
when fitting the generalized linear mixed model (default = 500)}

\item{fit.tol}{a positive number specifying tolerance, the difference threshold
for parameter estimates below which iterations should be stopped (default = 1e-5)}

\item{verbose}{include verbose output}
}
\value{
A \code{data.frame} containing the following named elements:
\itemize{
\item \code{loc:} ordinal number of SNP-CpG pair being analyzed
\item \code{numIDV:} number of observations of SNP-CpG pair being analyzed
\item \code{beta:} the fixed effect parameter estimate for the predictor of interest
\item \code{se_beta:} the standard deviation of fixed effect
\item \code{pvalue:} P value for the fixed effect, based on the Wald test
\item \code{h2:} heritability of the transformed rate
\item \code{sigma2:} total variance component
\item \code{converged:} a logical indicator for convergence
\item \code{time:} time to converge
}
}
\description{
Perform high-powered detection of genetic effects on DNA
methylation using integrated methylation QTL (methylation quantitative-trait locus)
mapping and allele-specific analysis.
}
\examples{

# This example demonstrates IMAGE:
\donttest{
  data(ExampleData)
  geno <- ExampleData$geno
  K <- ExampleData$K
  data <- ExampleData$data
  res=image(geno,data,K)
}

\donttest{
  # We've saved the results of the example above to show an example of
  # the outputs IMAGE produces:
  data(example_results)
}

# Toy example for testing purposes only:

geno <- list()
geno$hap1 = matrix(sample(c(0,1),25, replace = TRUE, prob = c(0.6,0.4)),
                    nrow = 5, ncol = 5)
geno$hap2 = matrix(sample(c(0,1),25, replace = TRUE, prob = c(0.6,0.4)),
                    nrow = 5, ncol = 5)

data <- list()
data$r = matrix(sample(0:50,25, replace = TRUE), nrow = 5, ncol = 5)
data$y = matrix(sample(0:50,25, replace = TRUE), nrow = 5, ncol = 5)
data$r1 = matrix(sample(0:50,25, replace = TRUE), nrow = 5, ncol = 5)
data$r2 = matrix(sample(0:50,25, replace = TRUE), nrow = 5, ncol = 5)
data$y1 = matrix(sample(0:50,25, replace = TRUE), nrow = 5, ncol = 5)
data$y2 = matrix(sample(0:50,25, replace = TRUE), nrow = 5, ncol = 5)

K = matrix(runif(25,-0.1,0.1), nrow = 5, ncol = 5)

res=image(geno,data,K)

\dontshow{
  closeAllConnections()
}

}
\references{
Fan, Y., Vilgalys, T.P., Sun, S., Peng, Q., Tung, J. and Zhou, X.,
2019. High-powered detection of genetic effects on DNA methylation using integrated
methylation QTL mapping and allele-specific analysis. bioRxiv, p.615039.
}
