% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_methods.R
\name{methods}
\alias{methods}
\alias{initial}
\alias{mu}
\alias{prior}
\alias{graph}
\alias{prec}
\title{Methods to work with a \code{model}.}
\usage{
initial(model)

mu(model, theta)

prior(model, theta)

graph(model, optimize)

prec(model, theta, optimize)
}
\arguments{
\item{model}{object to represent a model}

\item{theta}{numeric vector.
For \code{prior} it can be a numeric matrix,
with number of lines equal the size of \code{theta}
and each column as a different case.}

\item{optimize}{logical indicating if it is to be
returned only the elements and not as a sparse matrix.}
}
\value{
the result of the desired query
of the 'cgeneric' model.
'graph' and 'prec' can be either a vector
(if optimize = TRUE) or a sparse matrix.
}
\description{
For a given model object query the \code{initial},
\code{mu}, log \code{prior}, \code{graph} or precision \code{prec}
can be evaluated/retrieved.
}
\section{Functions}{
\itemize{
\item \code{initial()}: Retrieve the initial model parameter(s)

\item \code{mu()}: Evaluate the model's mean

\item \code{prior()}: Evaluate the log-prior for a given \code{theta}

\item \code{graph()}: Retrieve the models' graph

\item \code{prec()}: Retrieve the precision for a given \code{theta}

}}
\seealso{
\code{\link[=prior.cgeneric]{prior.cgeneric()}}
}
