% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{bootstrap_RT}
\alias{bootstrap_RT}
\title{Bootstrapping for running time samples}
\usage{
bootstrap_RT(x, max_eval, bootstrap.size)
}
\arguments{
\item{x}{A numeric vector. A sample of the running time.}

\item{max_eval}{A numeric vector, containing the maximal running time in
each run. It should have the same size as x}

\item{bootstrap.size}{integer, the size of the bootstrapped sample}
}
\value{
A numeric vector of the bootstrapped running time sample
}
\description{
Bootstrapping for running time samples
}
\examples{
ds <- dsl[[1]]
x <- get_RT_sample(ds, ftarget = 16, output = 'long')
max_eval <- get_maxRT(dsl, output = 'long')
bootstrap_RT(x$RT, max_eval$maxRT, bootstrap.size = 30)
}
