% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Algorithms.R
\name{IOH_random_search}
\alias{IOH_random_search}
\alias{random_search_PB}
\alias{random_search}
\title{IOHexperimenter-based wrapper}
\usage{
IOH_random_search(IOHproblem, budget = NULL)

random_search_PB(dim, obj_func, target_hit = function() {     FALSE },
  budget = NULL)

random_search(dim, obj_func, target_hit = function() {     FALSE },
  budget = NULL, lbound = -1, ubound = 1, maximize = T)
}
\arguments{
\item{IOHproblem}{An IOHproblem object}

\item{budget}{Integer, maximal allowable number of function evaluations}

\item{dim}{Dimension of search space}

\item{obj_func}{The evaluation function}

\item{target_hit}{Optional, function which enables early stopping if a target value is reached}

\item{lbound}{Lower bound of search space. Either single number or vector of size `dim`}

\item{ubound}{Upper bound of search space. Either single number or vector of size `dim`}

\item{maximize}{Whether to perform maximization or minimization. 
The function assumes minimization, achieved by inverting the obj_func when `maximize` is FALSE}
}
\description{
For easier use with the IOHexperimenter

Random walk in \eqn{{0, 1}^d} space; Maximization

Random walk in continuous space;
}
\examples{
\donttest{
benchmark_algorithm(IOH_random_search, data.dir = NULL)
}
}
