% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.extra.fill_CN.R
\name{ISRaD.extra.fill_CN}
\alias{ISRaD.extra.fill_CN}
\title{ISRaD.extra.fill_c_to_n}
\usage{
ISRaD.extra.fill_CN(database)
}
\arguments{
\item{database}{ISRaD dataset object}
}
\value{
ISRaD database object with gap-filled C:N data in new column ""
}
\description{
Calculates missing C:N ratios for records with reported C and N data
}
\details{
When possible, missing C:N ratios are calculated for records in the layer and fraction tables using reported values for organic C and total N. Variable "lyr_c_org_filled" must exist for function to work on layer table data. If you are running the function on a standard ISRaD database object (i.e. NOT ISRaD_extra) it is recommended to run the function "ISRaD.extra.Cstocks" first in order to create and fill the required "lyr_c_org_filled" column.
}
\examples{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
# Create lyr_c_org_filled column
database.x <- ISRaD.extra.Cstocks(database)
# Fill CN data
database.x <- ISRaD.extra.fill_CN(database.x)
}
\author{
Shane Stoner & J. Beem-Miller
}
