% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_periphery_weighted_function.R
\name{core_periphery_weighted}
\alias{core_periphery_weighted}
\title{Core-Periphery for Weighted Networks}
\usage{
core_periphery_weighted(gs, type)
}
\arguments{
\item{gs}{International Trade Network - igraph object.
Note for networks not produced using ITNr there needs to be a vertex attribute "name" and edge attribute "weight"}

\item{type}{directed/undirected}
}
\value{
List - 1.)igraph object with core-periphery results added as a node attribute.
2.) Dataframe of core-periphery results.
}
\description{
This function implements rich club core-periphery algorithm
(Ma & Mondragón, 2015) to identify members of the core and periphery in weighted networks
}
\examples{
require(igraph)
##Create random International Trade Network (igraph object)
ITN<-erdos.renyi.game(50,0.05,directed = TRUE)

##Add edge weights
E(ITN)$weight<-runif(ecount(ITN), 0, 1)

##Add vertex names
V(ITN)$name<-1:vcount(ITN)

##Implement core-periphery algorithm
ITNcp<-core_periphery_weighted(ITN,"directed")
}
\references{
Ma A, Mondragón RJ (2015) Rich-Cores in Networks. PLoS ONE 10(3): e0119678. https://doi.org/10.1371/journal.pone.0119678
}
