% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/validate.R
\name{validate}
\alias{validate}
\alias{validate_filename_output}
\title{Functions that check the validty of values throughout the workflow.}
\usage{
validate_filename_output(filename, path, file_extension_expected = "out",
  underscore_count_expected = 4L)
}
\arguments{
\item{filename}{The name of the file to be validated.}

\item{path}{The location of the file to be validated.}

\item{file_extension_expected}{The extension of the file.  This defaults to "out", which corresponds to Mplus output.}

\item{underscore_count_expected}{The number of underscores required in the name (not currently used).}
}
\value{
An \code{invisible} \code{TRUE} value if the filename is valid.  Otherwise, an error is thrown.
}
\description{
These functions help identify mistakes in formatting before the create difficult-to-diagnose problems later.
}
\examples{
library(IalsaSynthesis) #Load the package into the current R session.
\dontrun{
path <- "./studies/eas"
good_name <- "u1_male_aehplus_muscle_noCog_hand_noCogSpec.out"
validate_filename_output(good_name, path)

bad_name <- "missing_something.outtttt"
validate_filename_output(bad_name, path)
}
}
\author{
Will Beasley
}

