% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selfIntersections.R
\name{untwist}
\alias{untwist}
\title{Remove self-intersections}
\usage{
untwist(my_poly, plotting = FALSE, poly_name = "unspecified",
  min_area = 12.5)
}
\arguments{
\item{my_poly}{\code{SpatialPolygons} object from which self-intersections need to be removed}

\item{plotting}{boolean indicating if results should be plotted}

\item{poly_name}{name for \code{SpatialPolygons} object to return (defaults to "unspecified")}

\item{min_area}{minimum area for any individual polygon}
}
\value{
\code{SpatialPolygons} object with self-intersections removed
}
\description{
Function to remove all self-intersections from a contour.
}
\examples{
\dontrun{
par(mfrow = c(1, 2))
plot(interEx, main = "Original Contour")
noInter <- untwist(interEx, poly_name = "interEx")
plot(noInter, main = "Final Contour")
}
}
