% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mission_orbits.R
\name{revisit_time_RGTs}
\alias{revisit_time_RGTs}
\title{Revisit Time Reference Ground Tracks and Dates}
\usage{
revisit_time_RGTs(RGT_cycle = NULL, complete_date_sequence = FALSE)
}
\arguments{
\item{RGT_cycle}{either NULL or a character string specifying a single RGT (Reference Ground Track) as determined by the output of the 'available_RGTs(only_cycle_names = TRUE)' function. If NULL then all available Data will be returned.}

\item{complete_date_sequence}{a boolean. If TRUE a complete sequence of Dates will be returned, otherwise only the 'minimum' and 'maximum' Dates.}
}
\value{
a list object with the available orbit files, dates and date sequence lengths
}
\description{
Revisit Time Reference Ground Tracks and Dates
}
\details{
This function returns the .zip (kmz files) for all of the laser tracks over each 91-day repeat period (revisit time). Note that the locations and times are estimates, but
should be correct to within a few minutes in time and better than 100m in the predicted locations.

ICESat-2 was in safe-hold from June 26 through July 9, 2019. ATLAS was off during this time, so data was not collected or pointed to the reference ground track.
}
\examples{

require(IceSat2R)

#.......................................................
# receive all orbit files, dates and length of sequences
#.......................................................

rev_all = revisit_time_RGTs(RGT_cycle = NULL, complete_date_sequence = TRUE)
rev_all

#...................................................
# observe and choose one of the available RGT-cycles
#...................................................

avail_cycles = available_RGTs(only_cycle_names = TRUE,
                              verbose = TRUE)
avail_cycles

#.....................................
# receive results for a specific cycle
#.....................................

rev_cycle = revisit_time_RGTs(RGT_cycle = 'RGT_cycle_1', complete_date_sequence = FALSE)
rev_cycle
}
\references{
https://icesat-2.gsfc.nasa.gov/science/specs
}
