% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ne_10m_glaciated_areas}
\alias{ne_10m_glaciated_areas}
\title{Natural Earth 10m Glaciated Areas (1:10 million scale)}
\format{
An object of class \code{sf} (inherits from \code{data.frame}) with 68 rows and 6 columns.
}
\usage{
data(ne_10m_glaciated_areas)
}
\description{
Polygons derived from DCW (Digital Chart of the World), except for Antarctica derived from MOA. Includes name attributes for major polar glaciers.
Filtering has aggregated some minor glaciers and eliminated others from the original DCW data.
}
\details{
Issues: Needs scale rank attributes

Note: The original DCW data was collected decades ago. Since then many mountain glaciers have either disappeared or
diminished in size. This data theme is deliberately called "glaciated areas" instead of "glaciers" to reflect the
changeable character of glacier extents.
}
\examples{

require(IceSat2R)
require(sf)

data(ne_10m_glaciated_areas)
}
\references{
https://www.naturalearthdata.com/downloads/10m-physical-vectors/10m-glaciated-areas/
}
\keyword{datasets}
