/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tlong;

import cern.colt.function.tlong.LongIntProcedure;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tbyte.ByteArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.HashFunctions;
import cern.colt.map.tlong.AbstractLongIntMap;

public class OpenLongIntHashMap
extends AbstractLongIntMap {
    private static final long serialVersionUID = 1L;
    protected long[] table;
    protected int[] values;
    protected byte[] state;
    protected int freeEntries;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public OpenLongIntHashMap() {
        this(277);
    }

    public OpenLongIntHashMap(int n) {
        this(n, 0.2, 0.5);
    }

    public OpenLongIntHashMap(int n, double d, double d2) {
        this.setUp(n, d, d2);
    }

    public void clear() {
        new ByteArrayList(this.state).fillFromToWith(0, this.state.length - 1, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    public Object clone() {
        OpenLongIntHashMap openLongIntHashMap = (OpenLongIntHashMap)super.clone();
        openLongIntHashMap.table = (long[])openLongIntHashMap.table.clone();
        openLongIntHashMap.values = (int[])openLongIntHashMap.values.clone();
        openLongIntHashMap.state = (byte[])openLongIntHashMap.state.clone();
        return openLongIntHashMap;
    }

    public boolean containsKey(long l) {
        return this.indexOfKey(l) >= 0;
    }

    public boolean containsValue(int n) {
        return this.indexOfValue(n) >= 0;
    }

    public void ensureCapacity(int n) {
        if (this.table.length < n) {
            int n2 = this.nextPrime(n);
            this.rehash(n2);
        }
    }

    public boolean forEachKey(LongProcedure longProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || longProcedure.apply(this.table[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachPair(LongIntProcedure longIntProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || longIntProcedure.apply(this.table[n], this.values[n])) continue;
            return false;
        }
        return true;
    }

    public int get(long l) {
        int n = this.indexOfKey(l);
        if (n < 0) {
            return 0;
        }
        return this.values[n];
    }

    protected int indexOfInsertion(long l) {
        long[] lArray = this.table;
        byte[] byArray = this.state;
        int n = lArray.length;
        int n2 = HashFunctions.hash(l) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        int n4 = n2 % (n - 2);
        if (n4 == 0) {
            n4 = 1;
        }
        while (byArray[n3] == 1 && lArray[n3] != l) {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        }
        if (byArray[n3] == 2) {
            int n5 = n3;
            while (byArray[n3] != 0 && (byArray[n3] == 2 || lArray[n3] != l)) {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            }
            if (byArray[n3] == 0) {
                n3 = n5;
            }
        }
        if (byArray[n3] == 1) {
            return -n3 - 1;
        }
        return n3;
    }

    protected int indexOfKey(long l) {
        long[] lArray = this.table;
        byte[] byArray = this.state;
        int n = lArray.length;
        int n2 = HashFunctions.hash(l) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        int n4 = n2 % (n - 2);
        if (n4 == 0) {
            n4 = 1;
        }
        while (byArray[n3] != 0 && (byArray[n3] == 2 || lArray[n3] != l)) {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        }
        if (byArray[n3] == 0) {
            return -1;
        }
        return n3;
    }

    protected int indexOfValue(int n) {
        int[] nArray = this.values;
        byte[] byArray = this.state;
        int n2 = byArray.length;
        while (--n2 >= 0) {
            if (byArray[n2] != 1 || nArray[n2] != n) continue;
            return n2;
        }
        return -1;
    }

    public long keyOf(int n) {
        int n2 = this.indexOfValue(n);
        if (n2 < 0) {
            return Long.MIN_VALUE;
        }
        return this.table[n2];
    }

    public void keys(LongArrayList longArrayList) {
        longArrayList.setSize(this.distinct);
        long[] lArray = longArrayList.elements();
        long[] lArray2 = this.table;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = lArray2.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            lArray[n++] = lArray2[n2];
        }
    }

    public void pairsMatching(LongIntProcedure longIntProcedure, LongArrayList longArrayList, IntArrayList intArrayList) {
        longArrayList.clear();
        intArrayList.clear();
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || !longIntProcedure.apply(this.table[n], this.values[n])) continue;
            longArrayList.add(this.table[n]);
            intArrayList.add(this.values[n]);
        }
    }

    public boolean put(long l, int n) {
        int n2 = this.indexOfInsertion(l);
        if (n2 < 0) {
            n2 = -n2 - 1;
            this.values[n2] = n;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int n3 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n3);
            return this.put(l, n);
        }
        this.table[n2] = l;
        this.values[n2] = n;
        if (this.state[n2] == 0) {
            --this.freeEntries;
        }
        this.state[n2] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int n4 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n4);
        }
        return true;
    }

    protected void rehash(int n) {
        int n2 = this.table.length;
        long[] lArray = this.table;
        int[] nArray = this.values;
        byte[] byArray = this.state;
        long[] lArray2 = new long[n];
        int[] nArray2 = new int[n];
        byte[] byArray2 = new byte[n];
        this.lowWaterMark = this.chooseLowWaterMark(n, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(n, this.maxLoadFactor);
        this.table = lArray2;
        this.values = nArray2;
        this.state = byArray2;
        this.freeEntries = n - this.distinct;
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            long l = lArray[n3];
            int n4 = this.indexOfInsertion(l);
            lArray2[n4] = l;
            nArray2[n4] = nArray[n3];
            byArray2[n4] = 1;
        }
    }

    public boolean removeKey(long l) {
        int n = this.indexOfKey(l);
        if (n < 0) {
            return false;
        }
        this.state[n] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int n2 = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n2);
        }
        return true;
    }

    protected void setUp(int n, double d, double d2) {
        int n2 = n;
        super.setUp(n2, d, d2);
        n2 = this.nextPrime(n2);
        if (n2 == 0) {
            n2 = 1;
        }
        this.table = new long[n2];
        this.values = new int[n2];
        this.state = new byte[n2];
        this.minLoadFactor = d;
        this.maxLoadFactor = n2 == Integer.MAX_VALUE ? 1.0 : d2;
        this.distinct = 0;
        this.freeEntries = n2;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(n2, this.maxLoadFactor);
    }

    public void trimToSize() {
        int n = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > n) {
            this.rehash(n);
        }
    }

    public void values(IntArrayList intArrayList) {
        intArrayList.setSize(this.distinct);
        int[] nArray = intArrayList.elements();
        int[] nArray2 = this.values;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = byArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            nArray[n++] = nArray2[n2];
        }
    }
}

