/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.algo.IntFormatter;
import cern.colt.matrix.tint.algo.IntProperty;
import cern.colt.matrix.tint.algo.IntSorting;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class IntMatrix1D
extends AbstractMatrix1D {
    private static final long serialVersionUID = 1L;

    protected IntMatrix1D() {
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction) {
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = intFunction.apply(this.getQuick(0));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            int n3 = this.size / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.size : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = intFunction.apply(IntMatrix1D.this.getQuick(n4));
                        for (int i = n4 + 1; i < n5; ++i) {
                            n = intIntFunction.apply(n, intFunction.apply(IntMatrix1D.this.getQuick(i)));
                        }
                        return n;
                    }
                });
            }
            n = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            for (int i = 1; i < this.size; ++i) {
                n = intIntFunction.apply(n, intFunction.apply(this.getQuick(i)));
            }
        }
        return n;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction, IntArrayList intArrayList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        int n2 = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, n);
            Future[] futureArray = new Future[n3];
            int n4 = n / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = intFunction.apply(IntMatrix1D.this.getQuick(nArray[n5]));
                        for (int i = n5 + 1; i < n6; ++i) {
                            int n2 = IntMatrix1D.this.getQuick(nArray[i]);
                            n = intIntFunction.apply(n, intFunction.apply(n2));
                        }
                        return n;
                    }
                });
            }
            n2 = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n2 = intFunction.apply(this.getQuick(nArray[0]));
            for (int i = 1; i < n; ++i) {
                int n7 = this.getQuick(nArray[i]);
                n2 = intIntFunction.apply(n2, intFunction.apply(n7));
            }
        }
        return n2;
    }

    public int aggregate(final IntMatrix1D intMatrix1D, final IntIntFunction intIntFunction, final IntIntFunction intIntFunction2) {
        this.checkSize(intMatrix1D);
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = intIntFunction2.apply(this.getQuick(0), intMatrix1D.getQuick(0));
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            int n3 = this.size / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.size : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = intIntFunction2.apply(IntMatrix1D.this.getQuick(n4), intMatrix1D.getQuick(n4));
                        for (int i = n4 + 1; i < n5; ++i) {
                            n = intIntFunction.apply(n, intIntFunction2.apply(IntMatrix1D.this.getQuick(i), intMatrix1D.getQuick(i)));
                        }
                        return n;
                    }
                });
            }
            n = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            for (int i = 1; i < this.size; ++i) {
                n = intIntFunction.apply(n, intIntFunction2.apply(this.getQuick(i), intMatrix1D.getQuick(i)));
            }
        }
        return n;
    }

    public IntMatrix1D assign(final IntFunction intFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            IntMatrix1D.this.setQuick(i, intFunction.apply(IntMatrix1D.this.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, intFunction.apply(this.getQuick(i)));
            }
        }
        return this;
    }

    public IntMatrix1D assign(final IntProcedure intProcedure, final IntFunction intFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            int n = IntMatrix1D.this.getQuick(i);
                            if (!intProcedure.apply(n)) continue;
                            IntMatrix1D.this.setQuick(i, intFunction.apply(n));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                int n5 = this.getQuick(i);
                if (!intProcedure.apply(n5)) continue;
                this.setQuick(i, intFunction.apply(n5));
            }
        }
        return this;
    }

    public IntMatrix1D assign(final IntProcedure intProcedure, final int n) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            int n3 = this.size / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.size : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            int n2 = IntMatrix1D.this.getQuick(i);
                            if (!intProcedure.apply(n2)) continue;
                            IntMatrix1D.this.setQuick(i, n);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                int n6 = this.getQuick(i);
                if (!intProcedure.apply(n6)) continue;
                this.setQuick(i, n);
            }
        }
        return this;
    }

    public IntMatrix1D assign(final int n) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            int n3 = this.size / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.size : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            IntMatrix1D.this.setQuick(i, n);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, n);
            }
        }
        return this;
    }

    public IntMatrix1D assign(final int[] nArray) {
        if (nArray.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + nArray.length + "size()=" + this.size());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            IntMatrix1D.this.setQuick(i, nArray[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, nArray[i]);
            }
        }
        return this;
    }

    public IntMatrix1D assign(IntMatrix1D intMatrix1D) {
        if (intMatrix1D == this) {
            return this;
        }
        this.checkSize(intMatrix1D);
        final IntMatrix1D intMatrix1D2 = this.haveSharedCells(intMatrix1D) ? intMatrix1D.copy() : intMatrix1D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            IntMatrix1D.this.setQuick(i, intMatrix1D2.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, intMatrix1D2.getQuick(i));
            }
        }
        return this;
    }

    public IntMatrix1D assign(final IntMatrix1D intMatrix1D, final IntIntFunction intIntFunction) {
        this.checkSize(intMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            IntMatrix1D.this.setQuick(i, intIntFunction.apply(IntMatrix1D.this.getQuick(i), intMatrix1D.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, intIntFunction.apply(this.getQuick(i), intMatrix1D.getQuick(i)));
            }
        }
        return this;
    }

    public IntMatrix1D assign(IntMatrix1D intMatrix1D, IntIntFunction intIntFunction, IntArrayList intArrayList) {
        this.checkSize(intMatrix1D);
        int[] nArray = intArrayList.elements();
        if (intIntFunction == IntFunctions.mult) {
            int n = 0;
            int n2 = intArrayList.size();
            while (--n2 >= 0) {
                int n3 = nArray[n2];
                while (n < n3) {
                    this.setQuick(n, 0);
                    ++n;
                }
                this.setQuick(n3, this.getQuick(n3) * intMatrix1D.getQuick(n3));
                ++n;
            }
        } else if (intIntFunction instanceof IntPlusMultSecond) {
            int n = ((IntPlusMultSecond)intIntFunction).multiplicator;
            if (n == 0) {
                return this;
            }
            if (n == 1) {
                int n4 = intArrayList.size();
                while (--n4 >= 0) {
                    int n5 = nArray[n4];
                    this.setQuick(n5, this.getQuick(n5) + intMatrix1D.getQuick(n5));
                }
            } else if (n == -1) {
                int n6 = intArrayList.size();
                while (--n6 >= 0) {
                    int n7 = nArray[n6];
                    this.setQuick(n7, this.getQuick(n7) - intMatrix1D.getQuick(n7));
                }
            } else {
                int n8 = intArrayList.size();
                while (--n8 >= 0) {
                    int n9 = nArray[n8];
                    this.setQuick(n9, this.getQuick(n9) + n * intMatrix1D.getQuick(n9));
                }
            }
        } else {
            return this.assign(intMatrix1D, intIntFunction);
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            if (IntMatrix1D.this.getQuick(i) == 0) continue;
                            ++n;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.getQuick(i) == 0) continue;
                ++n;
            }
        }
        return n;
    }

    protected int cardinality(int n) {
        int n2 = 0;
        int n3 = this.size;
        while (--n3 >= 0 && n2 < n) {
            if (this.getQuick(n3) == 0) continue;
            ++n2;
        }
        return n2;
    }

    public IntMatrix1D copy() {
        IntMatrix1D intMatrix1D = this.like();
        intMatrix1D.assign(this);
        return intMatrix1D;
    }

    public abstract Object elements();

    public boolean equals(int n) {
        return IntProperty.DEFAULT.equals(this, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof IntMatrix1D)) {
            return false;
        }
        return IntProperty.DEFAULT.equals(this, (IntMatrix1D)object);
    }

    public int get(int n) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        return this.getQuick(n);
    }

    protected IntMatrix1D getContent() {
        return this;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2) {
        int n;
        intArrayList.clear();
        intArrayList2.clear();
        int n2 = this.size % 2;
        if (n2 == 1 && (n = this.getQuick(0)) < 0) {
            intArrayList.add(0);
            intArrayList2.add(n);
        }
        for (n = n2; n < this.size; n += 2) {
            int n3 = this.getQuick(n);
            if (n3 < 0) {
                intArrayList.add(n);
                intArrayList2.add(n3);
            }
            if ((n3 = this.getQuick(n + 1)) >= 0) continue;
            intArrayList.add(n + 1);
            intArrayList2.add(n3);
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2) {
        int n;
        intArrayList.clear();
        intArrayList2.clear();
        int n2 = this.size % 2;
        if (n2 == 1 && (n = this.getQuick(0)) != 0) {
            intArrayList.add(0);
            intArrayList2.add(n);
        }
        for (n = n2; n < this.size; n += 2) {
            int n3 = this.getQuick(n);
            if (n3 != 0) {
                intArrayList.add(n);
                intArrayList2.add(n3);
            }
            if ((n3 = this.getQuick(n + 1)) == 0) continue;
            intArrayList.add(n + 1);
            intArrayList2.add(n3);
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, int n) {
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = intArrayList2 != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            intArrayList2.clear();
        }
        int n2 = this.size;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.getQuick(i);
            if (n4 != 0) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    intArrayList2.add(n4);
                }
                ++n3;
            }
            if (n3 >= n) break;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2) {
        int n;
        intArrayList.clear();
        intArrayList2.clear();
        int n2 = this.size % 2;
        if (n2 == 1 && (n = this.getQuick(0)) > 0) {
            intArrayList.add(0);
            intArrayList2.add(n);
        }
        for (n = n2; n < this.size; n += 2) {
            int n3 = this.getQuick(n);
            if (n3 > 0) {
                intArrayList.add(n);
                intArrayList2.add(n3);
            }
            if ((n3 = this.getQuick(n + 1)) <= 0) continue;
            intArrayList.add(n + 1);
            intArrayList2.add(n3);
        }
    }

    public abstract int getQuick(int var1);

    protected boolean haveSharedCells(IntMatrix1D intMatrix1D) {
        if (intMatrix1D == null) {
            return false;
        }
        if (this == intMatrix1D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(intMatrix1D.getContent());
    }

    protected boolean haveSharedCellsRaw(IntMatrix1D intMatrix1D) {
        return false;
    }

    public IntMatrix1D like() {
        return this.like(this.size);
    }

    public abstract IntMatrix1D like(int var1);

    public abstract IntMatrix2D like2D(int var1, int var2);

    public int[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n4;
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int[][] nArray = new int[n3][2];
            int n5 = this.size / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.size : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = n6;
                        int n2 = IntMatrix1D.this.getQuick(n);
                        for (int i = n6 + 1; i < n7; ++i) {
                            int n3 = IntMatrix1D.this.getQuick(i);
                            if (n2 >= n3) continue;
                            n2 = n3;
                            n = i;
                        }
                        return new int[]{n2, n};
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    nArray[n4] = (int[])futureArray[n4].get();
                }
                n2 = nArray[0][0];
                n = nArray[0][1];
                for (n4 = 1; n4 < n3; ++n4) {
                    if (n2 >= nArray[n4][0]) continue;
                    n2 = nArray[n4][0];
                    n = nArray[n4][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n2 = this.getQuick(n);
            int n8 = 1;
            while ((long)n8 < this.size()) {
                int n9 = this.getQuick(n8);
                if (n2 < n9) {
                    n2 = n9;
                    n = n8;
                }
                ++n8;
            }
        }
        return new int[]{n2, n};
    }

    public int[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n4;
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int[][] nArray = new int[n3][2];
            int n5 = this.size / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.size : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = n6;
                        int n2 = IntMatrix1D.this.getQuick(n);
                        for (int i = n6 + 1; i < n7; ++i) {
                            int n3 = IntMatrix1D.this.getQuick(i);
                            if (n2 <= n3) continue;
                            n2 = n3;
                            n = i;
                        }
                        return new int[]{n2, n};
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    nArray[n4] = (int[])futureArray[n4].get();
                }
                n2 = nArray[0][0];
                n = nArray[0][1];
                for (n4 = 1; n4 < n3; ++n4) {
                    if (n2 <= nArray[n4][0]) continue;
                    n2 = nArray[n4][0];
                    n = nArray[n4][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n2 = this.getQuick(n);
            int n8 = 1;
            while ((long)n8 < this.size()) {
                int n9 = this.getQuick(n8);
                if (n2 > n9) {
                    n2 = n9;
                    n = n8;
                }
                ++n8;
            }
        }
        return new int[]{n2, n};
    }

    public abstract IntMatrix2D reshape(int var1, int var2);

    public abstract IntMatrix3D reshape(int var1, int var2, int var3);

    public void set(int n, int n2) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        this.setQuick(n, n2);
    }

    public abstract void setQuick(int var1, int var2);

    public void setSize(int n) {
        this.size = n;
    }

    public void swap(final IntMatrix1D intMatrix1D) {
        this.checkSize(intMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            int n = IntMatrix1D.this.getQuick(i);
                            IntMatrix1D.this.setQuick(i, intMatrix1D.getQuick(i));
                            intMatrix1D.setQuick(i, n);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                int n5 = this.getQuick(i);
                this.setQuick(i, intMatrix1D.getQuick(i));
                intMatrix1D.setQuick(i, n5);
            }
        }
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        this.toArray(nArray);
        return nArray;
    }

    public void toArray(final int[] nArray) {
        if (nArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            nArray[i] = IntMatrix1D.this.getQuick(i);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                nArray[i] = this.getQuick(i);
            }
        }
    }

    public String toString() {
        return new IntFormatter().toString(this);
    }

    protected IntMatrix1D view() {
        return (IntMatrix1D)this.clone();
    }

    public IntMatrix1D viewFlip() {
        return (IntMatrix1D)this.view().vFlip();
    }

    public IntMatrix1D viewPart(int n, int n2) {
        return (IntMatrix1D)this.view().vPart(n, n2);
    }

    public IntMatrix1D viewSelection(IntProcedure intProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.size; ++i) {
            if (!intProcedure.apply(this.getQuick(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements());
    }

    public IntMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                nArray[i] = i;
            }
        }
        this.checkIndexes(nArray);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = (int)this.index(nArray[i]);
        }
        return this.viewSelectionLike(nArray2);
    }

    protected abstract IntMatrix1D viewSelectionLike(int[] var1);

    public IntMatrix1D viewSorted() {
        return IntSorting.mergeSort.sort(this);
    }

    public IntMatrix1D viewStrides(int n) {
        return (IntMatrix1D)this.view().vStrides(n);
    }

    public int zDotProduct(IntMatrix1D intMatrix1D) {
        return this.zDotProduct(intMatrix1D, 0, this.size);
    }

    public int zDotProduct(final IntMatrix1D intMatrix1D, final int n, int n2) {
        if (n < 0 || n2 <= 0) {
            return 0;
        }
        int n3 = n + n2;
        if (this.size < n3) {
            n3 = this.size;
        }
        if (intMatrix1D.size < n3) {
            n3 = intMatrix1D.size;
        }
        n2 = n3 - n;
        int n4 = 0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n6;
            n5 = Math.min(n5, n2);
            Future[] futureArray = new Future[n5];
            Integer[] integerArray = new Integer[n5];
            int n7 = n2 / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? n2 : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n3 = 0;
                        for (int i = n8; i < n9; ++i) {
                            int n2 = i + n;
                            n3 += IntMatrix1D.this.getQuick(n2) * intMatrix1D.getQuick(n2);
                        }
                        return n3;
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    integerArray[n6] = (Integer)futureArray[n6].get();
                }
                n4 = integerArray[0];
                for (n6 = 1; n6 < n5; ++n6) {
                    n4 += integerArray[n6].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n10 = n3 - 1;
            int n11 = n2;
            while (--n11 >= 0) {
                n4 += this.getQuick(n10) * intMatrix1D.getQuick(n10);
                --n10;
            }
        }
        return n4;
    }

    public int zDotProduct(IntMatrix1D intMatrix1D, int n, int n2, IntArrayList intArrayList) {
        int n3;
        int n4;
        if (n < 0 || n2 <= 0) {
            return 0;
        }
        int n5 = n + n2;
        if (this.size < n5) {
            n5 = this.size;
        }
        if (intMatrix1D.size < n5) {
            n5 = intMatrix1D.size;
        }
        if ((n2 = n5 - n) <= 0) {
            return 0;
        }
        IntArrayList intArrayList2 = intArrayList.copy();
        intArrayList2.trimToSize();
        intArrayList2.quickSort();
        int[] nArray = intArrayList2.elements();
        int n6 = intArrayList2.size();
        for (n4 = 0; n4 < n6 && nArray[n4] < n; ++n4) {
        }
        int n7 = 0;
        while (--n2 >= 0 && n4 < n6 && (n3 = nArray[n4]) < n5) {
            n7 += this.getQuick(n3) * intMatrix1D.getQuick(n3);
            ++n4;
        }
        return n7;
    }

    protected int zDotProduct(IntMatrix1D intMatrix1D, IntArrayList intArrayList) {
        return this.zDotProduct(intMatrix1D, 0, this.size, intArrayList);
    }

    public int zSum() {
        if (this.size() == 0L) {
            return 0;
        }
        return this.aggregate(IntFunctions.plus, IntFunctions.identity);
    }
}

